// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a workflow run.
 */
public class WorkflowRunSummary private constructor(builder: Builder) {
    /**
     * The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The system-generated unique ID of the workflow run.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The status of the workflow run.
     */
    public val status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reasons for the workflow run status.
     */
    public val statusReasons: List<WorkflowRunStatusReason>? = builder.statusReasons
    /**
     * The system-generated unique ID of the workflow.
     */
    public val workflowId: kotlin.String = requireNotNull(builder.workflowId) { "A non-null value must be provided for workflowId" }
    /**
     * The name of the workflow.
     */
    public val workflowName: kotlin.String = requireNotNull(builder.workflowName) { "A non-null value must be provided for workflowName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowRunSummary(")
        append("endTime=$endTime,")
        append("id=$id,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReasons=$statusReasons,")
        append("workflowId=$workflowId,")
        append("workflowName=$workflowName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReasons?.hashCode() ?: 0)
        result = 31 * result + (workflowId.hashCode())
        result = 31 * result + (workflowName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowRunSummary

        if (endTime != other.endTime) return false
        if (id != other.id) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReasons != other.statusReasons) return false
        if (workflowId != other.workflowId) return false
        if (workflowName != other.workflowName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The system-generated unique ID of the workflow run.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the workflow run.
         */
        public var status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunStatus? = null
        /**
         * The reasons for the workflow run status.
         */
        public var statusReasons: List<WorkflowRunStatusReason>? = null
        /**
         * The system-generated unique ID of the workflow.
         */
        public var workflowId: kotlin.String? = null
        /**
         * The name of the workflow.
         */
        public var workflowName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunSummary) : this() {
            this.endTime = x.endTime
            this.id = x.id
            this.lastUpdatedTime = x.lastUpdatedTime
            this.startTime = x.startTime
            this.status = x.status
            this.statusReasons = x.statusReasons
            this.workflowId = x.workflowId
            this.workflowName = x.workflowName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunSummary = WorkflowRunSummary(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = WorkflowRunStatus.SdkUnknown("no value provided")
            if (workflowId == null) workflowId = ""
            if (workflowName == null) workflowName = ""
            return this
        }
    }
}
