// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetWorkflowResponse private constructor(builder: Builder) {
    /**
     * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * Information about the workflow definition file for the workflow.
     */
    public val definition: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition? = builder.definition
    /**
     * The ID of the workflow.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the workflow.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The behavior to use when multiple workflows occur at the same time. For more information, see [https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html](https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html) in the Amazon CodeCatalyst User Guide.
     */
    public val runMode: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunMode = requireNotNull(builder.runMode) { "A non-null value must be provided for runMode" }
    /**
     * The name of the branch that contains the workflow YAML.
     */
    public val sourceBranchName: kotlin.String? = builder.sourceBranchName
    /**
     * The name of the source repository where the workflow YAML is stored.
     */
    public val sourceRepositoryName: kotlin.String? = builder.sourceRepositoryName
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }
    /**
     * The status of the workflow.
     */
    public val status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetWorkflowResponse(")
        append("createdTime=$createdTime,")
        append("definition=$definition,")
        append("id=$id,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("projectName=$projectName,")
        append("runMode=$runMode,")
        append("sourceBranchName=$sourceBranchName,")
        append("sourceRepositoryName=$sourceRepositoryName,")
        append("spaceName=$spaceName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (runMode.hashCode())
        result = 31 * result + (sourceBranchName?.hashCode() ?: 0)
        result = 31 * result + (sourceRepositoryName?.hashCode() ?: 0)
        result = 31 * result + (spaceName.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetWorkflowResponse

        if (createdTime != other.createdTime) return false
        if (definition != other.definition) return false
        if (id != other.id) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (projectName != other.projectName) return false
        if (runMode != other.runMode) return false
        if (sourceBranchName != other.sourceBranchName) return false
        if (sourceRepositoryName != other.sourceRepositoryName) return false
        if (spaceName != other.spaceName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the workflow definition file for the workflow.
         */
        public var definition: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition? = null
        /**
         * The ID of the workflow.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the workflow.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The behavior to use when multiple workflows occur at the same time. For more information, see [https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html](https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html) in the Amazon CodeCatalyst User Guide.
         */
        public var runMode: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunMode? = null
        /**
         * The name of the branch that contains the workflow YAML.
         */
        public var sourceBranchName: kotlin.String? = null
        /**
         * The name of the source repository where the workflow YAML is stored.
         */
        public var sourceRepositoryName: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The status of the workflow.
         */
        public var status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse) : this() {
            this.createdTime = x.createdTime
            this.definition = x.definition
            this.id = x.id
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.projectName = x.projectName
            this.runMode = x.runMode
            this.sourceBranchName = x.sourceBranchName
            this.sourceRepositoryName = x.sourceRepositoryName
            this.spaceName = x.spaceName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse = GetWorkflowResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (projectName == null) projectName = ""
            if (runMode == null) runMode = WorkflowRunMode.SdkUnknown("no value provided")
            if (spaceName == null) spaceName = ""
            if (status == null) status = WorkflowStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
