// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a workflow.
 */
public class WorkflowSummary private constructor(builder: Builder) {
    /**
     * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * Information about the workflow definition file.
     */
    public val definition: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinitionSummary? = builder.definition
    /**
     * The system-generated unique ID of a workflow.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the workflow.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The run mode of the workflow.
     */
    public val runMode: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunMode = requireNotNull(builder.runMode) { "A non-null value must be provided for runMode" }
    /**
     * The name of the branch of the source repository where the workflow definition file is stored.
     */
    public val sourceBranchName: kotlin.String = requireNotNull(builder.sourceBranchName) { "A non-null value must be provided for sourceBranchName" }
    /**
     * The name of the source repository where the workflow definition file is stored.
     */
    public val sourceRepositoryName: kotlin.String = requireNotNull(builder.sourceRepositoryName) { "A non-null value must be provided for sourceRepositoryName" }
    /**
     * The status of the workflow.
     */
    public val status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.WorkflowSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowSummary(")
        append("createdTime=$createdTime,")
        append("definition=$definition,")
        append("id=$id,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("runMode=$runMode,")
        append("sourceBranchName=$sourceBranchName,")
        append("sourceRepositoryName=$sourceRepositoryName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (runMode.hashCode())
        result = 31 * result + (sourceBranchName.hashCode())
        result = 31 * result + (sourceRepositoryName.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowSummary

        if (createdTime != other.createdTime) return false
        if (definition != other.definition) return false
        if (id != other.id) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (runMode != other.runMode) return false
        if (sourceBranchName != other.sourceBranchName) return false
        if (sourceRepositoryName != other.sourceRepositoryName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.WorkflowSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the workflow definition file.
         */
        public var definition: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinitionSummary? = null
        /**
         * The system-generated unique ID of a workflow.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the workflow.
         */
        public var name: kotlin.String? = null
        /**
         * The run mode of the workflow.
         */
        public var runMode: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunMode? = null
        /**
         * The name of the branch of the source repository where the workflow definition file is stored.
         */
        public var sourceBranchName: kotlin.String? = null
        /**
         * The name of the source repository where the workflow definition file is stored.
         */
        public var sourceRepositoryName: kotlin.String? = null
        /**
         * The status of the workflow.
         */
        public var status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.WorkflowSummary) : this() {
            this.createdTime = x.createdTime
            this.definition = x.definition
            this.id = x.id
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.runMode = x.runMode
            this.sourceBranchName = x.sourceBranchName
            this.sourceRepositoryName = x.sourceRepositoryName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.WorkflowSummary = WorkflowSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinitionSummary] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinitionSummary.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinitionSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (runMode == null) runMode = WorkflowRunMode.SdkUnknown("no value provided")
            if (sourceBranchName == null) sourceBranchName = ""
            if (sourceRepositoryName == null) sourceRepositoryName = ""
            if (status == null) status = WorkflowStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
