// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowSortCriteria
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ListWorkflowsOperationSerializer: HttpSerializer.NonStreaming<ListWorkflowsRequest> {
    override fun serialize(context: ExecutionContext, input: ListWorkflowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.spaceName) { "spaceName is bound to the URI and must not be null" }
            require(input.spaceName?.isNotBlank() == true) { "spaceName is bound to the URI and must be a non-blank value" }
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("spaces"))
                add(PercentEncoding.SmithyLabel.encode("${input.spaceName}"))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode("${input.projectName}"))
                add(PercentEncoding.Path.encode("workflows"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                require(input.nextToken?.isNotBlank() == true) { "nextToken is bound to the URI and must be a non-blank value" }
                if (input.maxResults != null) add("maxResults", "${input.maxResults}")
                if (input.nextToken != null) add("nextToken", input.nextToken)
            }
        }

        val payload = serializeListWorkflowsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListWorkflowsOperationBody(context: ExecutionContext, input: ListWorkflowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val SORTBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sortBy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SORTBY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.sortBy != null) {
            listField(SORTBY_DESCRIPTOR) {
                for (el0 in input.sortBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeWorkflowSortCriteriaDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
