// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateAccessTokenOperationDeserializer: HttpDeserializer.NonStreaming<CreateAccessTokenResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAccessTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAccessTokenError(context, call, payload)
        }
        val builder = CreateAccessTokenResponse.Builder()

        if (payload != null) {
            deserializeCreateAccessTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAccessTokenError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessTokenOperationBody(builder: CreateAccessTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSTOKENID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessTokenId"))
    val EXPIRESTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiresTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SECRET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("secret"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKENID_DESCRIPTOR)
        field(EXPIRESTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECRET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSTOKENID_DESCRIPTOR.index -> builder.accessTokenId = deserializeString()
                EXPIRESTIME_DESCRIPTOR.index -> builder.expiresTime = deserializeString().let { Instant.fromIso8601(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECRET_DESCRIPTOR.index -> builder.secret = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
