// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.paginators

import aws.sdk.kotlin.services.codecatalyst.CodeCatalystClient
import aws.sdk.kotlin.services.codecatalyst.model.AccessTokenSummary
import aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSessionSummary
import aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSummary
import aws.sdk.kotlin.services.codecatalyst.model.EventLogEntry
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesItem
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesItem
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowRunsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowRunsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ProjectSummary
import aws.sdk.kotlin.services.codecatalyst.model.SpaceSummary
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunSummary
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccessTokensResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessTokensRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessTokensResponse]
 */
public fun CodeCatalystClient.listAccessTokensPaginated(initialRequest: ListAccessTokensRequest = ListAccessTokensRequest { }): Flow<ListAccessTokensResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessTokensPaginated.listAccessTokens(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessTokensResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessTokensResponse]
 */
public fun CodeCatalystClient.listAccessTokensPaginated(block: ListAccessTokensRequest.Builder.() -> Unit): Flow<ListAccessTokensResponse> =
    listAccessTokensPaginated(ListAccessTokensRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessTokensPaginated]
 * to access the nested member [AccessTokenSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessTokenSummary]
 */
@JvmName("listAccessTokensResponseAccessTokenSummary")
public fun Flow<ListAccessTokensResponse>.items(): Flow<AccessTokenSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDevEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevEnvironmentsResponse]
 */
public fun CodeCatalystClient.listDevEnvironmentsPaginated(initialRequest: ListDevEnvironmentsRequest): Flow<ListDevEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevEnvironmentsPaginated.listDevEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevEnvironmentsResponse]
 */
public fun CodeCatalystClient.listDevEnvironmentsPaginated(block: ListDevEnvironmentsRequest.Builder.() -> Unit): Flow<ListDevEnvironmentsResponse> =
    listDevEnvironmentsPaginated(ListDevEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDevEnvironmentsPaginated]
 * to access the nested member [DevEnvironmentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DevEnvironmentSummary]
 */
@JvmName("listDevEnvironmentsResponseDevEnvironmentSummary")
public fun Flow<ListDevEnvironmentsResponse>.items(): Flow<DevEnvironmentSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDevEnvironmentSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevEnvironmentSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevEnvironmentSessionsResponse]
 */
public fun CodeCatalystClient.listDevEnvironmentSessionsPaginated(initialRequest: ListDevEnvironmentSessionsRequest): Flow<ListDevEnvironmentSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevEnvironmentSessionsPaginated.listDevEnvironmentSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevEnvironmentSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevEnvironmentSessionsResponse]
 */
public fun CodeCatalystClient.listDevEnvironmentSessionsPaginated(block: ListDevEnvironmentSessionsRequest.Builder.() -> Unit): Flow<ListDevEnvironmentSessionsResponse> =
    listDevEnvironmentSessionsPaginated(ListDevEnvironmentSessionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDevEnvironmentSessionsPaginated]
 * to access the nested member [DevEnvironmentSessionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DevEnvironmentSessionSummary]
 */
@JvmName("listDevEnvironmentSessionsResponseDevEnvironmentSessionSummary")
public fun Flow<ListDevEnvironmentSessionsResponse>.items(): Flow<DevEnvironmentSessionSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventLogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventLogsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventLogsResponse]
 */
public fun CodeCatalystClient.listEventLogsPaginated(initialRequest: ListEventLogsRequest): Flow<ListEventLogsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventLogsPaginated.listEventLogs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventLogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventLogsResponse]
 */
public fun CodeCatalystClient.listEventLogsPaginated(block: ListEventLogsRequest.Builder.() -> Unit): Flow<ListEventLogsResponse> =
    listEventLogsPaginated(ListEventLogsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventLogsPaginated]
 * to access the nested member [EventLogEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventLogEntry]
 */
@JvmName("listEventLogsResponseEventLogEntry")
public fun Flow<ListEventLogsResponse>.items(): Flow<EventLogEntry> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun CodeCatalystClient.listProjectsPaginated(initialRequest: ListProjectsRequest): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun CodeCatalystClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [ProjectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectSummary]
 */
@JvmName("listProjectsResponseProjectSummary")
public fun Flow<ListProjectsResponse>.items(): Flow<ProjectSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSourceRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSourceRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoriesResponse]
 */
public fun CodeCatalystClient.listSourceRepositoriesPaginated(initialRequest: ListSourceRepositoriesRequest): Flow<ListSourceRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSourceRepositoriesPaginated.listSourceRepositories(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSourceRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoriesResponse]
 */
public fun CodeCatalystClient.listSourceRepositoriesPaginated(block: ListSourceRepositoriesRequest.Builder.() -> Unit): Flow<ListSourceRepositoriesResponse> =
    listSourceRepositoriesPaginated(ListSourceRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSourceRepositoriesPaginated]
 * to access the nested member [ListSourceRepositoriesItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoriesItem]
 */
@JvmName("listSourceRepositoriesResponseListSourceRepositoriesItem")
public fun Flow<ListSourceRepositoriesResponse>.items(): Flow<ListSourceRepositoriesItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSourceRepositoryBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSourceRepositoryBranchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoryBranchesResponse]
 */
public fun CodeCatalystClient.listSourceRepositoryBranchesPaginated(initialRequest: ListSourceRepositoryBranchesRequest): Flow<ListSourceRepositoryBranchesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSourceRepositoryBranchesPaginated.listSourceRepositoryBranches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSourceRepositoryBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoryBranchesResponse]
 */
public fun CodeCatalystClient.listSourceRepositoryBranchesPaginated(block: ListSourceRepositoryBranchesRequest.Builder.() -> Unit): Flow<ListSourceRepositoryBranchesResponse> =
    listSourceRepositoryBranchesPaginated(ListSourceRepositoryBranchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSourceRepositoryBranchesPaginated]
 * to access the nested member [ListSourceRepositoryBranchesItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceRepositoryBranchesItem]
 */
@JvmName("listSourceRepositoryBranchesResponseListSourceRepositoryBranchesItem")
public fun Flow<ListSourceRepositoryBranchesResponse>.items(): Flow<ListSourceRepositoryBranchesItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSpacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSpacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpacesResponse]
 */
public fun CodeCatalystClient.listSpacesPaginated(initialRequest: ListSpacesRequest = ListSpacesRequest { }): Flow<ListSpacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSpacesPaginated.listSpaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSpacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpacesResponse]
 */
public fun CodeCatalystClient.listSpacesPaginated(block: ListSpacesRequest.Builder.() -> Unit): Flow<ListSpacesResponse> =
    listSpacesPaginated(ListSpacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSpacesPaginated]
 * to access the nested member [SpaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SpaceSummary]
 */
@JvmName("listSpacesResponseSpaceSummary")
public fun Flow<ListSpacesResponse>.items(): Flow<SpaceSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowRunsResponse]
 */
public fun CodeCatalystClient.listWorkflowRunsPaginated(initialRequest: ListWorkflowRunsRequest): Flow<ListWorkflowRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowRunsPaginated.listWorkflowRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowRunsResponse]
 */
public fun CodeCatalystClient.listWorkflowRunsPaginated(block: ListWorkflowRunsRequest.Builder.() -> Unit): Flow<ListWorkflowRunsResponse> =
    listWorkflowRunsPaginated(ListWorkflowRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowRunsPaginated]
 * to access the nested member [WorkflowRunSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowRunSummary]
 */
@JvmName("listWorkflowRunsResponseWorkflowRunSummary")
public fun Flow<ListWorkflowRunsResponse>.items(): Flow<WorkflowRunSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun CodeCatalystClient.listWorkflowsPaginated(initialRequest: ListWorkflowsRequest): Flow<ListWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowsPaginated.listWorkflows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun CodeCatalystClient.listWorkflowsPaginated(block: ListWorkflowsRequest.Builder.() -> Unit): Flow<ListWorkflowsResponse> =
    listWorkflowsPaginated(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowsPaginated]
 * to access the nested member [WorkflowSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowSummary]
 */
@JvmName("listWorkflowsResponseWorkflowSummary")
public fun Flow<ListWorkflowsResponse>.items(): Flow<WorkflowSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
