// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetSourceRepositoryResponse private constructor(builder: Builder) {
    /**
     * The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The description of the source repository.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the source repository.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSourceRepositoryResponse(")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("projectName=$projectName,")
        append("spaceName=$spaceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (spaceName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSourceRepositoryResponse

        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (projectName != other.projectName) return false
        if (spaceName != other.spaceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the source repository.
         */
        public var description: kotlin.String? = null
        /**
         * The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the source repository.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryResponse) : this() {
            this.createdTime = x.createdTime
            this.description = x.description
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.projectName = x.projectName
            this.spaceName = x.spaceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryResponse = GetSourceRepositoryResponse(this)

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (projectName == null) projectName = ""
            if (spaceName == null) spaceName = ""
            return this
        }
    }
}
