// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.DeleteSourceRepositoryResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteSourceRepositoryOperationDeserializer: HttpDeserialize<DeleteSourceRepositoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteSourceRepositoryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteSourceRepositoryError(context, call)
        }
        val builder = DeleteSourceRepositoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteSourceRepositoryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteSourceRepositoryError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteSourceRepositoryOperationBody(builder: DeleteSourceRepositoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spaceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAME_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
