// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model



public class StartDevEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The system-generated unique ID of the Dev Environment.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    public val ides: List<IdeConfiguration>? = builder.ides
    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    public val inactivityTimeoutMinutes: kotlin.Int = builder.inactivityTimeoutMinutes
    /**
     * The Amazon EC2 instace type to use for the Dev Environment.
     */
    public val instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = builder.instanceType
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDevEnvironmentRequest(")
        append("id=$id,")
        append("ides=$ides,")
        append("inactivityTimeoutMinutes=$inactivityTimeoutMinutes,")
        append("instanceType=$instanceType,")
        append("projectName=$projectName,")
        append("spaceName=$spaceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (ides?.hashCode() ?: 0)
        result = 31 * result + (inactivityTimeoutMinutes)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (spaceName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDevEnvironmentRequest

        if (id != other.id) return false
        if (ides != other.ides) return false
        if (inactivityTimeoutMinutes != other.inactivityTimeoutMinutes) return false
        if (instanceType != other.instanceType) return false
        if (projectName != other.projectName) return false
        if (spaceName != other.spaceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The system-generated unique ID of the Dev Environment.
         */
        public var id: kotlin.String? = null
        /**
         * Information about the integrated development environment (IDE) configured for a Dev Environment.
         */
        public var ides: List<IdeConfiguration>? = null
        /**
         * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
         */
        public var inactivityTimeoutMinutes: kotlin.Int = 0
        /**
         * The Amazon EC2 instace type to use for the Dev Environment.
         */
        public var instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest) : this() {
            this.id = x.id
            this.ides = x.ides
            this.inactivityTimeoutMinutes = x.inactivityTimeoutMinutes
            this.instanceType = x.instanceType
            this.projectName = x.projectName
            this.spaceName = x.spaceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest = StartDevEnvironmentRequest(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (projectName == null) projectName = ""
            if (spaceName == null) spaceName = ""
            return this
        }
    }
}
