// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetWorkflowRunResponse private constructor(builder: Builder) {
    /**
     * The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ID of the workflow run.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time the workflow run status was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }
    /**
     * The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The status of the workflow run.
     */
    public val status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Information about the reasons for the status of the workflow run.
     */
    public val statusReasons: List<WorkflowRunStatusReason>? = builder.statusReasons
    /**
     * The ID of the workflow.
     */
    public val workflowId: kotlin.String = requireNotNull(builder.workflowId) { "A non-null value must be provided for workflowId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetWorkflowRunResponse(")
        append("endTime=$endTime,")
        append("id=$id,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("projectName=$projectName,")
        append("spaceName=$spaceName,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReasons=$statusReasons,")
        append("workflowId=$workflowId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (spaceName.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReasons?.hashCode() ?: 0)
        result = 31 * result + (workflowId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetWorkflowRunResponse

        if (endTime != other.endTime) return false
        if (id != other.id) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (projectName != other.projectName) return false
        if (spaceName != other.spaceName) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReasons != other.statusReasons) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the workflow run.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time the workflow run status was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the workflow run.
         */
        public var status: aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunStatus? = null
        /**
         * Information about the reasons for the status of the workflow run.
         */
        public var statusReasons: List<WorkflowRunStatusReason>? = null
        /**
         * The ID of the workflow.
         */
        public var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunResponse) : this() {
            this.endTime = x.endTime
            this.id = x.id
            this.lastUpdatedTime = x.lastUpdatedTime
            this.projectName = x.projectName
            this.spaceName = x.spaceName
            this.startTime = x.startTime
            this.status = x.status
            this.statusReasons = x.statusReasons
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunResponse = GetWorkflowRunResponse(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (projectName == null) projectName = ""
            if (spaceName == null) spaceName = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = WorkflowRunStatus.SdkUnknown("no value provided")
            if (workflowId == null) workflowId = ""
            return this
        }
    }
}
