// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.transform

import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.IdeConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.InstanceType
import aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.RepositoryInput
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDevEnvironmentOperationSerializer: HttpSerialize<CreateDevEnvironmentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDevEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "spaces",
                "${input.spaceName}".encodeLabel(),
                "projects",
                "${input.projectName}".encodeLabel(),
                "devEnvironments",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateDevEnvironmentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDevEnvironmentOperationBody(context: ExecutionContext, input: CreateDevEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val IDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ides"))
    val INACTIVITYTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("inactivityTimeoutMinutes"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val PERSISTENTSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("persistentStorage"))
    val REPOSITORIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("repositories"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(IDES_DESCRIPTOR)
        field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(PERSISTENTSTORAGE_DESCRIPTOR)
        field(REPOSITORIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alias?.let { field(ALIAS_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        if (input.ides != null) {
            listField(IDES_DESCRIPTOR) {
                for (el0 in input.ides) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdeConfigurationDocument))
                }
            }
        }
        if (input.inactivityTimeoutMinutes != 0) field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR, input.inactivityTimeoutMinutes)
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it.value) }
        input.persistentStorage?.let { field(PERSISTENTSTORAGE_DESCRIPTOR, it, ::serializePersistentStorageConfigurationDocument) }
        if (input.repositories != null) {
            listField(REPOSITORIES_DESCRIPTOR) {
                for (el0 in input.repositories) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRepositoryInputDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
