// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListEventLogsRequest private constructor(builder: Builder) {
    /**
     * The time after which you do not want any events retrieved, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The name of the event.
     */
    public val eventName: kotlin.String? = builder.eventName
    /**
     * The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a `NextToken` element, which you can use to obtain additional results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token returned from a call to this API to indicate the next batch of results to return, if any.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String? = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }
    /**
     * The date and time when you want to start retrieving events, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEventLogsRequest(")
        append("endTime=$endTime,")
        append("eventName=$eventName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("spaceName=$spaceName,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (spaceName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEventLogsRequest

        if (endTime != other.endTime) return false
        if (eventName != other.eventName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (spaceName != other.spaceName) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time after which you do not want any events retrieved, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the event.
         */
        public var eventName: kotlin.String? = null
        /**
         * The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a `NextToken` element, which you can use to obtain additional results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token returned from a call to this API to indicate the next batch of results to return, if any.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The date and time when you want to start retrieving events, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest) : this() {
            this.endTime = x.endTime
            this.eventName = x.eventName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.spaceName = x.spaceName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest = ListEventLogsRequest(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (spaceName == null) spaceName = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
