// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a Dev Environment.
 */
public class DevEnvironmentSummary private constructor(builder: Builder) {
    /**
     * The user-specified alias for the Dev Environment.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The system-generated unique ID of the user who created the Dev Environment.
     */
    public val creatorId: kotlin.String? = builder.creatorId
    /**
     * The system-generated unique ID for the Dev Environment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    public val ides: List<Ide>? = builder.ides
    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Dev Environments consume compute minutes when running.
     */
    public val inactivityTimeoutMinutes: kotlin.Int = builder.inactivityTimeoutMinutes
    /**
     * The Amazon EC2 instace type used for the Dev Environment.
     */
    public val instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = builder.instanceType
    /**
     * The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * Information about the configuration of persistent storage for the Dev Environment.
     */
    public val persistentStorage: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorage? = builder.persistentStorage
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * Information about the repositories that will be cloned into the Dev Environment. If no rvalue is specified, no repository is cloned.
     */
    public val repositories: List<DevEnvironmentRepositorySummary>? = builder.repositories
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String? = builder.spaceName
    /**
     * The status of the Dev Environment.
     */
    public val status: aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentStatus? = builder.status
    /**
     * The reason for the status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DevEnvironmentSummary(")
        append("alias=$alias,")
        append("creatorId=$creatorId,")
        append("id=$id,")
        append("ides=$ides,")
        append("inactivityTimeoutMinutes=$inactivityTimeoutMinutes,")
        append("instanceType=$instanceType,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("persistentStorage=$persistentStorage,")
        append("projectName=$projectName,")
        append("repositories=$repositories,")
        append("spaceName=$spaceName,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (creatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ides?.hashCode() ?: 0)
        result = 31 * result + (inactivityTimeoutMinutes)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (persistentStorage?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (repositories?.hashCode() ?: 0)
        result = 31 * result + (spaceName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DevEnvironmentSummary

        if (alias != other.alias) return false
        if (creatorId != other.creatorId) return false
        if (id != other.id) return false
        if (ides != other.ides) return false
        if (inactivityTimeoutMinutes != other.inactivityTimeoutMinutes) return false
        if (instanceType != other.instanceType) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (persistentStorage != other.persistentStorage) return false
        if (projectName != other.projectName) return false
        if (repositories != other.repositories) return false
        if (spaceName != other.spaceName) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user-specified alias for the Dev Environment.
         */
        public var alias: kotlin.String? = null
        /**
         * The system-generated unique ID of the user who created the Dev Environment.
         */
        public var creatorId: kotlin.String? = null
        /**
         * The system-generated unique ID for the Dev Environment.
         */
        public var id: kotlin.String? = null
        /**
         * Information about the integrated development environment (IDE) configured for a Dev Environment.
         */
        public var ides: List<Ide>? = null
        /**
         * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Dev Environments consume compute minutes when running.
         */
        public var inactivityTimeoutMinutes: kotlin.Int = 0
        /**
         * The Amazon EC2 instace type used for the Dev Environment.
         */
        public var instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = null
        /**
         * The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the configuration of persistent storage for the Dev Environment.
         */
        public var persistentStorage: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorage? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * Information about the repositories that will be cloned into the Dev Environment. If no rvalue is specified, no repository is cloned.
         */
        public var repositories: List<DevEnvironmentRepositorySummary>? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The status of the Dev Environment.
         */
        public var status: aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentStatus? = null
        /**
         * The reason for the status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSummary) : this() {
            this.alias = x.alias
            this.creatorId = x.creatorId
            this.id = x.id
            this.ides = x.ides
            this.inactivityTimeoutMinutes = x.inactivityTimeoutMinutes
            this.instanceType = x.instanceType
            this.lastUpdatedTime = x.lastUpdatedTime
            this.persistentStorage = x.persistentStorage
            this.projectName = x.projectName
            this.repositories = x.repositories
            this.spaceName = x.spaceName
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSummary = DevEnvironmentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.PersistentStorage] inside the given [block]
         */
        public fun persistentStorage(block: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorage.Builder.() -> kotlin.Unit) {
            this.persistentStorage = aws.sdk.kotlin.services.codecatalyst.model.PersistentStorage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creatorId == null) creatorId = ""
            if (id == null) id = ""
            if (inactivityTimeoutMinutes == null) inactivityTimeoutMinutes = 0
            if (instanceType == null) instanceType = InstanceType.SdkUnknown("no value provided")
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (persistentStorage == null) persistentStorage = PersistentStorage.Builder().correctErrors().build()
            if (repositories == null) repositories = emptyList()
            if (status == null) status = DevEnvironmentStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
