// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a specified personal access token (PAT).
 */
public class AccessTokenSummary private constructor(builder: Builder) {
    /**
     * The date and time when the personal access token will expire, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val expiresTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresTime
    /**
     * The system-generated ID of the personal access token.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The friendly name of the personal access token.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.AccessTokenSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessTokenSummary(")
        append("expiresTime=$expiresTime,")
        append("id=$id,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expiresTime?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessTokenSummary

        if (expiresTime != other.expiresTime) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.AccessTokenSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time when the personal access token will expire, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var expiresTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The system-generated ID of the personal access token.
         */
        public var id: kotlin.String? = null
        /**
         * The friendly name of the personal access token.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.AccessTokenSummary) : this() {
            this.expiresTime = x.expiresTime
            this.id = x.id
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.AccessTokenSummary = AccessTokenSummary(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
