// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.endpoints

import aws.sdk.kotlin.services.codecatalyst.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultCodeCatalystEndpointProvider: CodeCatalystEndpointProvider {
    public override suspend fun resolveEndpoint(params: CodeCatalystEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            return Endpoint(
                Url.parse(params.endpoint, UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
            )
        }
        run {
            val partitionResult = partition("us-west-2")
            if (
                partitionResult != null &&
                !(params.region != null)
            ) {
                if (
                    params.useFips == true
                ) {
                    if (
                        partitionResult?.supportsFIPS == false
                    ) {
                        throw EndpointProviderException("Partition does not support FIPS.")
                    }
                    return Endpoint(
                        Url.parse("https://codecatalyst-fips.global.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
                return Endpoint(
                    Url.parse("https://codecatalyst.global.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                )
            }
        }
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.region != null
            ) {
                if (
                    params.useFips == true
                ) {
                    if (
                        partitionResult?.supportsFIPS == false
                    ) {
                        throw EndpointProviderException("Partition does not support FIPS.")
                    }
                    return Endpoint(
                        Url.parse("https://codecatalyst-fips.global.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
                return Endpoint(
                    Url.parse("https://codecatalyst.global.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
