// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.transform

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.IdeConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.InstanceType
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateDevEnvironmentOperationDeserializer: HttpDeserialize<UpdateDevEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDevEnvironmentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDevEnvironmentError(context, response)
        }
        val builder = UpdateDevEnvironmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDevEnvironmentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateDevEnvironmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDevEnvironmentOperationBody(builder: UpdateDevEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val IDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ides"))
    val INACTIVITYTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("inactivityTimeoutMinutes"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spaceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(IDES_DESCRIPTOR)
        field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                CLIENTTOKEN_DESCRIPTOR.index -> builder.clientToken = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                IDES_DESCRIPTOR.index -> builder.ides =
                    deserializer.deserializeList(IDES_DESCRIPTOR) {
                        val col0 = mutableListOf<IdeConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdeConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INACTIVITYTIMEOUTMINUTES_DESCRIPTOR.index -> builder.inactivityTimeoutMinutes = deserializeInt()
                INSTANCETYPE_DESCRIPTOR.index -> builder.instanceType = deserializeString().let { InstanceType.fromValue(it) }
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
