// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an entry in an event log of Amazon CodeCatalyst activity.
 */
public class EventLogEntry private constructor(builder: Builder) {
    /**
     * The code of the error, if any.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The category for the event.
     */
    public val eventCategory: kotlin.String? = builder.eventCategory
    /**
     * The name of the event.
     */
    public val eventName: kotlin.String? = builder.eventName
    /**
     * The source of the event.
     */
    public val eventSource: kotlin.String? = builder.eventSource
    /**
     * The time the event took place, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The type of the event.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * The system-generated unique ID of the event.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The type of the event.
     */
    public val operationType: aws.sdk.kotlin.services.codecatalyst.model.OperationType? = builder.operationType
    /**
     * Information about the project where the event occurred.
     */
    public val projectInformation: aws.sdk.kotlin.services.codecatalyst.model.ProjectInformation? = builder.projectInformation
    /**
     * The system-generated unique ID of the request.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * Information about the payload of the request.
     */
    public val requestPayload: aws.sdk.kotlin.services.codecatalyst.model.EventPayload? = builder.requestPayload
    /**
     * Information about the payload of the response, if any.
     */
    public val responsePayload: aws.sdk.kotlin.services.codecatalyst.model.EventPayload? = builder.responsePayload
    /**
     * The IP address of the user whose actions are recorded in the event.
     */
    public val sourceIpAddress: kotlin.String? = builder.sourceIpAddress
    /**
     *
     */
    public val userAgent: kotlin.String? = builder.userAgent
    /**
     * The system-generated unique ID of the user whose actions are recorded in the event.
     */
    public val userIdentity: aws.sdk.kotlin.services.codecatalyst.model.UserIdentity? = builder.userIdentity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.EventLogEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventLogEntry(")
        append("errorCode=$errorCode,")
        append("eventCategory=$eventCategory,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("eventTime=$eventTime,")
        append("eventType=$eventType,")
        append("id=$id,")
        append("operationType=$operationType,")
        append("projectInformation=$projectInformation,")
        append("requestId=$requestId,")
        append("requestPayload=$requestPayload,")
        append("responsePayload=$responsePayload,")
        append("sourceIpAddress=$sourceIpAddress,")
        append("userAgent=$userAgent,")
        append("userIdentity=$userIdentity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (eventCategory?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (projectInformation?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (requestPayload?.hashCode() ?: 0)
        result = 31 * result + (responsePayload?.hashCode() ?: 0)
        result = 31 * result + (sourceIpAddress?.hashCode() ?: 0)
        result = 31 * result + (userAgent?.hashCode() ?: 0)
        result = 31 * result + (userIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventLogEntry

        if (errorCode != other.errorCode) return false
        if (eventCategory != other.eventCategory) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (eventTime != other.eventTime) return false
        if (eventType != other.eventType) return false
        if (id != other.id) return false
        if (operationType != other.operationType) return false
        if (projectInformation != other.projectInformation) return false
        if (requestId != other.requestId) return false
        if (requestPayload != other.requestPayload) return false
        if (responsePayload != other.responsePayload) return false
        if (sourceIpAddress != other.sourceIpAddress) return false
        if (userAgent != other.userAgent) return false
        if (userIdentity != other.userIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.EventLogEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The code of the error, if any.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The category for the event.
         */
        public var eventCategory: kotlin.String? = null
        /**
         * The name of the event.
         */
        public var eventName: kotlin.String? = null
        /**
         * The source of the event.
         */
        public var eventSource: kotlin.String? = null
        /**
         * The time the event took place, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of the event.
         */
        public var eventType: kotlin.String? = null
        /**
         * The system-generated unique ID of the event.
         */
        public var id: kotlin.String? = null
        /**
         * The type of the event.
         */
        public var operationType: aws.sdk.kotlin.services.codecatalyst.model.OperationType? = null
        /**
         * Information about the project where the event occurred.
         */
        public var projectInformation: aws.sdk.kotlin.services.codecatalyst.model.ProjectInformation? = null
        /**
         * The system-generated unique ID of the request.
         */
        public var requestId: kotlin.String? = null
        /**
         * Information about the payload of the request.
         */
        public var requestPayload: aws.sdk.kotlin.services.codecatalyst.model.EventPayload? = null
        /**
         * Information about the payload of the response, if any.
         */
        public var responsePayload: aws.sdk.kotlin.services.codecatalyst.model.EventPayload? = null
        /**
         * The IP address of the user whose actions are recorded in the event.
         */
        public var sourceIpAddress: kotlin.String? = null
        /**
         *
         */
        public var userAgent: kotlin.String? = null
        /**
         * The system-generated unique ID of the user whose actions are recorded in the event.
         */
        public var userIdentity: aws.sdk.kotlin.services.codecatalyst.model.UserIdentity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.EventLogEntry) : this() {
            this.errorCode = x.errorCode
            this.eventCategory = x.eventCategory
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.eventTime = x.eventTime
            this.eventType = x.eventType
            this.id = x.id
            this.operationType = x.operationType
            this.projectInformation = x.projectInformation
            this.requestId = x.requestId
            this.requestPayload = x.requestPayload
            this.responsePayload = x.responsePayload
            this.sourceIpAddress = x.sourceIpAddress
            this.userAgent = x.userAgent
            this.userIdentity = x.userIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.EventLogEntry = EventLogEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.ProjectInformation] inside the given [block]
         */
        public fun projectInformation(block: aws.sdk.kotlin.services.codecatalyst.model.ProjectInformation.Builder.() -> kotlin.Unit) {
            this.projectInformation = aws.sdk.kotlin.services.codecatalyst.model.ProjectInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.EventPayload] inside the given [block]
         */
        public fun requestPayload(block: aws.sdk.kotlin.services.codecatalyst.model.EventPayload.Builder.() -> kotlin.Unit) {
            this.requestPayload = aws.sdk.kotlin.services.codecatalyst.model.EventPayload.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.EventPayload] inside the given [block]
         */
        public fun responsePayload(block: aws.sdk.kotlin.services.codecatalyst.model.EventPayload.Builder.() -> kotlin.Unit) {
            this.responsePayload = aws.sdk.kotlin.services.codecatalyst.model.EventPayload.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.UserIdentity] inside the given [block]
         */
        public fun userIdentity(block: aws.sdk.kotlin.services.codecatalyst.model.UserIdentity.Builder.() -> kotlin.Unit) {
            this.userIdentity = aws.sdk.kotlin.services.codecatalyst.model.UserIdentity.invoke(block)
        }
    }
}
