// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.endpoints

import aws.sdk.kotlin.services.codecatalyst.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        run {
            val partitionResult = partition("us-west-2")
            if (
                partitionResult != null &&
                !(params.region != null)
            ) {
                if (
                    params.useFips == true
                ) {
                    if (
                        partitionResult?.supportsFIPS == false
                    ) {
                        throw EndpointProviderException("Partition does not support FIPS.")
                    }
                    return Endpoint(
                        Url.parse("https://codecatalyst-fips.global.${partitionResult?.dualStackDnsSuffix}"),
                    )
                }
                return Endpoint(
                    Url.parse("https://codecatalyst.global.${partitionResult?.dualStackDnsSuffix}"),
                )
            }
        }
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.region != null
            ) {
                if (
                    params.useFips == true
                ) {
                    if (
                        partitionResult?.supportsFIPS == false
                    ) {
                        throw EndpointProviderException("Partition does not support FIPS.")
                    }
                    return Endpoint(
                        Url.parse("https://codecatalyst-fips.global.${partitionResult?.dualStackDnsSuffix}"),
                    )
                }
                return Endpoint(
                    Url.parse("https://codecatalyst.global.${partitionResult?.dualStackDnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
