// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codecatalyst.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codecatalyst.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryBranchResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteAccessTokenResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSpaceRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSpaceResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetUserDetailsRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetUserDetailsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesResponse
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentSessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentSessionResponse
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentSessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentSessionResponse
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.VerifySessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.VerifySessionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * **Amazon CodeCatalyst is in preview release and subject to change.**
 *
 * Welcome to the Amazon CodeCatalyst API reference. This reference provides descriptions of operations and data types for Amazon CodeCatalyst. You can use the Amazon CodeCatalyst API to work with the following objects.
 *
 * Dev Environments and the Amazon Web Services Toolkits, by calling the following:
 * + CreateAccessToken, which creates a personal access token (PAT) for the current user.
 * + CreateDevEnvironment, which creates a Dev Environment, where you can quickly work on the code stored in the source repositories of your project.
 * + CreateProject which creates a project in a specified space.
 * + CreateSourceRepositoryBranch, which creates a branch in a specified repository where you can work on code.
 * + DeleteDevEnvironment, which deletes a Dev Environment.
 * + GetDevEnvironment, which returns information about a Dev Environment.
 * + GetProject, which returns information about a project.
 * + GetSourceRepositoryCloneUrls, which returns information about the URLs that can be used with a Git client to clone a source repository.
 * + GetSubscription, which returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
 * + GetUserDetails, which returns information about a user in Amazon CodeCatalyst.
 * + ListDevEnvironments, which retrives a list of Dev Environments in a project.
 * + ListProjects, which retrieves a list of projects in a space.
 * + ListSourceRepositories, which retrieves a list of source repositories in a project.
 * + ListSourceRepositoryBranches, which retrieves a list of branches in a source repository.
 * + ListSpaces, which retrieves a list of spaces.
 * + StartDevEnvironment, which starts a specified Dev Environment and puts it into an active state.
 * + StartDevEnvironmentSession, which starts a session to a specified Dev Environment.
 * + StopDevEnvironment, which stops a specified Dev Environment and puts it into an stopped state.
 * + StopDevEnvironmentSession, which stops a session for a specified Dev Environment.
 * + UpdateDevEnvironment, which changes one or more values for a Dev Environment.
 * + VerifySession, which verifies whether the calling user has a valid Amazon CodeCatalyst login and session.
 *
 * Security, activity, and resource management in Amazon CodeCatalyst, by calling the following:
 * + DeleteAccessToken, which deletes a specified personal access token (PAT).
 * + ListAccessTokens, which lists all personal access tokens (PATs) associated with a user.
 * + ListEventLogs, which retrieves a list of events that occurred during a specified time period in a space.
 */
public interface CodeCatalystClient : SdkClient {

    override val serviceName: String
        get() = "CodeCatalyst"
    /**
     * CodeCatalystClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeCatalystClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeCatalystClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeCatalystClient = DefaultCodeCatalystClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodeCatalyst")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user account. You use PATs to access Amazon CodeCatalyst resources such as source repositories from third-party applications like Git and integrated development environments (IDEs). For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
     */
    public suspend fun createAccessToken(input: CreateAccessTokenRequest): CreateAccessTokenResponse

    /**
     * Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development Dev Environment that you can use to quickly work on the code stored in the source repositories of your project.
     *
     * When created in the Amazon CodeCatalyst console, by default a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage. None of these defaults apply to a Dev Environment created programmatically.
     */
    public suspend fun createDevEnvironment(input: CreateDevEnvironmentRequest): CreateDevEnvironmentResponse

    /**
     * Creates a project in a specified space.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a branch in a specified source repository in Amazon CodeCatalyst.
     *
     * This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.
     */
    public suspend fun createSourceRepositoryBranch(input: CreateSourceRepositoryBranchRequest): CreateSourceRepositoryBranchResponse

    /**
     * Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
     */
    public suspend fun deleteAccessToken(input: DeleteAccessTokenRequest): DeleteAccessTokenResponse

    /**
     * Deletes a Dev Environment.
     */
    public suspend fun deleteDevEnvironment(input: DeleteDevEnvironmentRequest): DeleteDevEnvironmentResponse

    /**
     * Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
     */
    public suspend fun getDevEnvironment(input: GetDevEnvironmentRequest): GetDevEnvironmentResponse

    /**
     * Returns information about a project.
     */
    public suspend fun getProject(input: GetProjectRequest): GetProjectResponse

    /**
     * Returns information about the URLs that can be used with a Git client to clone a source repository.
     */
    public suspend fun getSourceRepositoryCloneUrls(input: GetSourceRepositoryCloneUrlsRequest): GetSourceRepositoryCloneUrlsResponse

    /**
     * Returns information about an space.
     */
    public suspend fun getSpace(input: GetSpaceRequest): GetSpaceResponse

    /**
     * Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
     */
    public suspend fun getSubscription(input: GetSubscriptionRequest): GetSubscriptionResponse

    /**
     * Returns information about a user.
     */
    public suspend fun getUserDetails(input: GetUserDetailsRequest = GetUserDetailsRequest {}): GetUserDetailsResponse

    /**
     * Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your user account.
     */
    public suspend fun listAccessTokens(input: ListAccessTokensRequest = ListAccessTokensRequest {}): ListAccessTokensResponse

    /**
     * Retrives a list of Dev Environments in a project.
     */
    public suspend fun listDevEnvironments(input: ListDevEnvironmentsRequest): ListDevEnvironmentsResponse

    /**
     * Retrieves a list of events that occurred during a specified time period in a space. You can use these events to audit user and system activity in a space.
     */
    public suspend fun listEventLogs(input: ListEventLogsRequest): ListEventLogsResponse

    /**
     * Retrieves a list of projects.
     */
    public suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Retrieves a list of source repositories in a project.
     */
    public suspend fun listSourceRepositories(input: ListSourceRepositoriesRequest): ListSourceRepositoriesResponse

    /**
     * Retrieves a list of branches in a specified source repository.
     */
    public suspend fun listSourceRepositoryBranches(input: ListSourceRepositoryBranchesRequest): ListSourceRepositoryBranchesResponse

    /**
     * Retrieves a list of spaces.
     */
    public suspend fun listSpaces(input: ListSpacesRequest = ListSpacesRequest {}): ListSpacesResponse

    /**
     * Starts a specified Dev Environment and puts it into an active state.
     */
    public suspend fun startDevEnvironment(input: StartDevEnvironmentRequest): StartDevEnvironmentResponse

    /**
     * Starts a session for a specified Dev Environment.
     */
    public suspend fun startDevEnvironmentSession(input: StartDevEnvironmentSessionRequest): StartDevEnvironmentSessionResponse

    /**
     * Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
     */
    public suspend fun stopDevEnvironment(input: StopDevEnvironmentRequest): StopDevEnvironmentResponse

    /**
     * Stops a session for a specified Dev Environment.
     */
    public suspend fun stopDevEnvironmentSession(input: StopDevEnvironmentSessionRequest): StopDevEnvironmentSessionResponse

    /**
     * Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
     */
    public suspend fun updateDevEnvironment(input: UpdateDevEnvironmentRequest): UpdateDevEnvironmentResponse

    /**
     * Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
     */
    public suspend fun verifySession(input: VerifySessionRequest = VerifySessionRequest {}): VerifySessionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeCatalystClient.withConfig(block: CodeCatalystClient.Config.Builder.() -> Unit): CodeCatalystClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeCatalystClient(newConfig)
}

/**
 * Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user account. You use PATs to access Amazon CodeCatalyst resources such as source repositories from third-party applications like Git and integrated development environments (IDEs). For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
 */
public suspend inline fun CodeCatalystClient.createAccessToken(crossinline block: CreateAccessTokenRequest.Builder.() -> Unit): CreateAccessTokenResponse = createAccessToken(CreateAccessTokenRequest.Builder().apply(block).build())

/**
 * Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development Dev Environment that you can use to quickly work on the code stored in the source repositories of your project.
 *
 * When created in the Amazon CodeCatalyst console, by default a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage. None of these defaults apply to a Dev Environment created programmatically.
 */
public suspend inline fun CodeCatalystClient.createDevEnvironment(crossinline block: CreateDevEnvironmentRequest.Builder.() -> Unit): CreateDevEnvironmentResponse = createDevEnvironment(CreateDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a project in a specified space.
 */
public suspend inline fun CodeCatalystClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates a branch in a specified source repository in Amazon CodeCatalyst.
 *
 * This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.
 */
public suspend inline fun CodeCatalystClient.createSourceRepositoryBranch(crossinline block: CreateSourceRepositoryBranchRequest.Builder.() -> Unit): CreateSourceRepositoryBranchResponse = createSourceRepositoryBranch(CreateSourceRepositoryBranchRequest.Builder().apply(block).build())

/**
 * Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
 */
public suspend inline fun CodeCatalystClient.deleteAccessToken(crossinline block: DeleteAccessTokenRequest.Builder.() -> Unit): DeleteAccessTokenResponse = deleteAccessToken(DeleteAccessTokenRequest.Builder().apply(block).build())

/**
 * Deletes a Dev Environment.
 */
public suspend inline fun CodeCatalystClient.deleteDevEnvironment(crossinline block: DeleteDevEnvironmentRequest.Builder.() -> Unit): DeleteDevEnvironmentResponse = deleteDevEnvironment(DeleteDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
 */
public suspend inline fun CodeCatalystClient.getDevEnvironment(crossinline block: GetDevEnvironmentRequest.Builder.() -> Unit): GetDevEnvironmentResponse = getDevEnvironment(GetDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns information about a project.
 */
public suspend inline fun CodeCatalystClient.getProject(crossinline block: GetProjectRequest.Builder.() -> Unit): GetProjectResponse = getProject(GetProjectRequest.Builder().apply(block).build())

/**
 * Returns information about the URLs that can be used with a Git client to clone a source repository.
 */
public suspend inline fun CodeCatalystClient.getSourceRepositoryCloneUrls(crossinline block: GetSourceRepositoryCloneUrlsRequest.Builder.() -> Unit): GetSourceRepositoryCloneUrlsResponse = getSourceRepositoryCloneUrls(GetSourceRepositoryCloneUrlsRequest.Builder().apply(block).build())

/**
 * Returns information about an space.
 */
public suspend inline fun CodeCatalystClient.getSpace(crossinline block: GetSpaceRequest.Builder.() -> Unit): GetSpaceResponse = getSpace(GetSpaceRequest.Builder().apply(block).build())

/**
 * Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
 */
public suspend inline fun CodeCatalystClient.getSubscription(crossinline block: GetSubscriptionRequest.Builder.() -> Unit): GetSubscriptionResponse = getSubscription(GetSubscriptionRequest.Builder().apply(block).build())

/**
 * Returns information about a user.
 */
public suspend inline fun CodeCatalystClient.getUserDetails(crossinline block: GetUserDetailsRequest.Builder.() -> Unit): GetUserDetailsResponse = getUserDetails(GetUserDetailsRequest.Builder().apply(block).build())

/**
 * Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your user account.
 */
public suspend inline fun CodeCatalystClient.listAccessTokens(crossinline block: ListAccessTokensRequest.Builder.() -> Unit): ListAccessTokensResponse = listAccessTokens(ListAccessTokensRequest.Builder().apply(block).build())

/**
 * Retrives a list of Dev Environments in a project.
 */
public suspend inline fun CodeCatalystClient.listDevEnvironments(crossinline block: ListDevEnvironmentsRequest.Builder.() -> Unit): ListDevEnvironmentsResponse = listDevEnvironments(ListDevEnvironmentsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of events that occurred during a specified time period in a space. You can use these events to audit user and system activity in a space.
 */
public suspend inline fun CodeCatalystClient.listEventLogs(crossinline block: ListEventLogsRequest.Builder.() -> Unit): ListEventLogsResponse = listEventLogs(ListEventLogsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of projects.
 */
public suspend inline fun CodeCatalystClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of source repositories in a project.
 */
public suspend inline fun CodeCatalystClient.listSourceRepositories(crossinline block: ListSourceRepositoriesRequest.Builder.() -> Unit): ListSourceRepositoriesResponse = listSourceRepositories(ListSourceRepositoriesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of branches in a specified source repository.
 */
public suspend inline fun CodeCatalystClient.listSourceRepositoryBranches(crossinline block: ListSourceRepositoryBranchesRequest.Builder.() -> Unit): ListSourceRepositoryBranchesResponse = listSourceRepositoryBranches(ListSourceRepositoryBranchesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of spaces.
 */
public suspend inline fun CodeCatalystClient.listSpaces(crossinline block: ListSpacesRequest.Builder.() -> Unit): ListSpacesResponse = listSpaces(ListSpacesRequest.Builder().apply(block).build())

/**
 * Starts a specified Dev Environment and puts it into an active state.
 */
public suspend inline fun CodeCatalystClient.startDevEnvironment(crossinline block: StartDevEnvironmentRequest.Builder.() -> Unit): StartDevEnvironmentResponse = startDevEnvironment(StartDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Starts a session for a specified Dev Environment.
 */
public suspend inline fun CodeCatalystClient.startDevEnvironmentSession(crossinline block: StartDevEnvironmentSessionRequest.Builder.() -> Unit): StartDevEnvironmentSessionResponse = startDevEnvironmentSession(StartDevEnvironmentSessionRequest.Builder().apply(block).build())

/**
 * Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
 */
public suspend inline fun CodeCatalystClient.stopDevEnvironment(crossinline block: StopDevEnvironmentRequest.Builder.() -> Unit): StopDevEnvironmentResponse = stopDevEnvironment(StopDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Stops a session for a specified Dev Environment.
 */
public suspend inline fun CodeCatalystClient.stopDevEnvironmentSession(crossinline block: StopDevEnvironmentSessionRequest.Builder.() -> Unit): StopDevEnvironmentSessionResponse = stopDevEnvironmentSession(StopDevEnvironmentSessionRequest.Builder().apply(block).build())

/**
 * Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
 */
public suspend inline fun CodeCatalystClient.updateDevEnvironment(crossinline block: UpdateDevEnvironmentRequest.Builder.() -> Unit): UpdateDevEnvironmentResponse = updateDevEnvironment(UpdateDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
 */
public suspend inline fun CodeCatalystClient.verifySession(crossinline block: VerifySessionRequest.Builder.() -> Unit): VerifySessionResponse = verifySession(VerifySessionRequest.Builder().apply(block).build())
