// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.transform

import aws.sdk.kotlin.services.codecatalyst.model.IdeConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.InstanceType
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartDevEnvironmentOperationSerializer: HttpSerialize<StartDevEnvironmentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartDevEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "spaces",
                "${input.spaceName}".encodeLabel(),
                "projects",
                "${input.projectName}".encodeLabel(),
                "devEnvironments",
                "${input.id}".encodeLabel(),
                "start",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeStartDevEnvironmentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartDevEnvironmentOperationBody(context: ExecutionContext, input: StartDevEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val IDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ides"))
    val INACTIVITYTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("inactivityTimeoutMinutes"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDES_DESCRIPTOR)
        field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.ides != null) {
            listField(IDES_DESCRIPTOR) {
                for (el0 in input.ides) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdeConfigurationDocument))
                }
            }
        }
        if (input.inactivityTimeoutMinutes != 0) field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR, input.inactivityTimeoutMinutes)
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
