// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model



public class CreateDevEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The user-defined alias for a Dev Environment.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     *
     * An IDE is required to create a Dev Environment. For Dev Environment creation, this field contains configuration information and must be provided.
     */
    public val ides: List<IdeConfiguration>? = builder.ides
    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    public val inactivityTimeoutMinutes: kotlin.Int = builder.inactivityTimeoutMinutes
    /**
     * The Amazon EC2 instace type to use for the Dev Environment.
     */
    public val instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = builder.instanceType
    /**
     * Information about the amount of storage allocated to the Dev Environment. By default, a Dev Environment is configured to have 16GB of persistent storage.
     *
     * Valid values for persistent storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
     */
    public val persistentStorage: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration? = builder.persistentStorage
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String? = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The source repository that contains the branch to clone into the Dev Environment.
     */
    public val repositories: List<RepositoryInput>? = builder.repositories
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String? = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDevEnvironmentRequest(")
        append("alias=$alias,")
        append("clientToken=$clientToken,")
        append("ides=$ides,")
        append("inactivityTimeoutMinutes=$inactivityTimeoutMinutes,")
        append("instanceType=$instanceType,")
        append("persistentStorage=$persistentStorage,")
        append("projectName=$projectName,")
        append("repositories=$repositories,")
        append("spaceName=$spaceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (ides?.hashCode() ?: 0)
        result = 31 * result + (inactivityTimeoutMinutes)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (persistentStorage?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (repositories?.hashCode() ?: 0)
        result = 31 * result + (spaceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDevEnvironmentRequest

        if (alias != other.alias) return false
        if (clientToken != other.clientToken) return false
        if (ides != other.ides) return false
        if (inactivityTimeoutMinutes != other.inactivityTimeoutMinutes) return false
        if (instanceType != other.instanceType) return false
        if (persistentStorage != other.persistentStorage) return false
        if (projectName != other.projectName) return false
        if (repositories != other.repositories) return false
        if (spaceName != other.spaceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user-defined alias for a Dev Environment.
         */
        public var alias: kotlin.String? = null
        /**
         * A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Information about the integrated development environment (IDE) configured for a Dev Environment.
         *
         * An IDE is required to create a Dev Environment. For Dev Environment creation, this field contains configuration information and must be provided.
         */
        public var ides: List<IdeConfiguration>? = null
        /**
         * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
         */
        public var inactivityTimeoutMinutes: kotlin.Int = 0
        /**
         * The Amazon EC2 instace type to use for the Dev Environment.
         */
        public var instanceType: aws.sdk.kotlin.services.codecatalyst.model.InstanceType? = null
        /**
         * Information about the amount of storage allocated to the Dev Environment. By default, a Dev Environment is configured to have 16GB of persistent storage.
         *
         * Valid values for persistent storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
         */
        public var persistentStorage: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The source repository that contains the branch to clone into the Dev Environment.
         */
        public var repositories: List<RepositoryInput>? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest) : this() {
            this.alias = x.alias
            this.clientToken = x.clientToken
            this.ides = x.ides
            this.inactivityTimeoutMinutes = x.inactivityTimeoutMinutes
            this.instanceType = x.instanceType
            this.persistentStorage = x.persistentStorage
            this.projectName = x.projectName
            this.repositories = x.repositories
            this.spaceName = x.spaceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest = CreateDevEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration] inside the given [block]
         */
        public fun persistentStorage(block: aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration.Builder.() -> kotlin.Unit) {
            this.persistentStorage = aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration.invoke(block)
        }
    }
}
