// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codecatalyst.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.codecatalyst.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.codecatalyst.model.*
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSpaceRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetUserDetailsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentSessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.VerifySessionRequest
import aws.sdk.kotlin.services.codecatalyst.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "CodeCatalyst"
public const val ServiceApiVersion: String = "2022-09-28"
public const val SdkVersion: String = "0.19.5-beta"

internal class DefaultCodeCatalystClient(override val config: CodeCatalystClient.Config) : CodeCatalystClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user account. You use PATs to access Amazon CodeCatalyst resources such as source repositories from third-party applications like Git and integrated development environments (IDEs). For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
     */
    override suspend fun createAccessToken(input: CreateAccessTokenRequest): CreateAccessTokenResponse {
        val op = SdkHttpOperation.build<CreateAccessTokenRequest, CreateAccessTokenResponse> {
            serializer = CreateAccessTokenOperationSerializer()
            deserializer = CreateAccessTokenOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAccessToken"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateAccessTokenRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAccessToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development Dev Environment that you can use to quickly work on the code stored in the source repositories of your project. By default, a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage.
     */
    override suspend fun createDevEnvironment(input: CreateDevEnvironmentRequest): CreateDevEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateDevEnvironmentRequest, CreateDevEnvironmentResponse> {
            serializer = CreateDevEnvironmentOperationSerializer()
            deserializer = CreateDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a project in a specified space.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateProject"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateProjectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateProject-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a branch in a specified source repository in Amazon CodeCatalyst.
     *
     * This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.
     */
    override suspend fun createSourceRepositoryBranch(input: CreateSourceRepositoryBranchRequest): CreateSourceRepositoryBranchResponse {
        val op = SdkHttpOperation.build<CreateSourceRepositoryBranchRequest, CreateSourceRepositoryBranchResponse> {
            serializer = CreateSourceRepositoryBranchOperationSerializer()
            deserializer = CreateSourceRepositoryBranchOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSourceRepositoryBranch"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSourceRepositoryBranchRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSourceRepositoryBranch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
     */
    override suspend fun deleteAccessToken(input: DeleteAccessTokenRequest): DeleteAccessTokenResponse {
        val op = SdkHttpOperation.build<DeleteAccessTokenRequest, DeleteAccessTokenResponse> {
            serializer = DeleteAccessTokenOperationSerializer()
            deserializer = DeleteAccessTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccessToken"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAccessTokenRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAccessToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Dev Environment.
     */
    override suspend fun deleteDevEnvironment(input: DeleteDevEnvironmentRequest): DeleteDevEnvironmentResponse {
        val op = SdkHttpOperation.build<DeleteDevEnvironmentRequest, DeleteDevEnvironmentResponse> {
            serializer = DeleteDevEnvironmentOperationSerializer()
            deserializer = DeleteDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
     */
    override suspend fun getDevEnvironment(input: GetDevEnvironmentRequest): GetDevEnvironmentResponse {
        val op = SdkHttpOperation.build<GetDevEnvironmentRequest, GetDevEnvironmentResponse> {
            serializer = GetDevEnvironmentOperationSerializer()
            deserializer = GetDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a project.
     */
    override suspend fun getProject(input: GetProjectRequest): GetProjectResponse {
        val op = SdkHttpOperation.build<GetProjectRequest, GetProjectResponse> {
            serializer = GetProjectOperationSerializer()
            deserializer = GetProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProject"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetProjectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetProject-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the URLs that can be used with a Git client to clone a source repository.
     */
    override suspend fun getSourceRepositoryCloneUrls(input: GetSourceRepositoryCloneUrlsRequest): GetSourceRepositoryCloneUrlsResponse {
        val op = SdkHttpOperation.build<GetSourceRepositoryCloneUrlsRequest, GetSourceRepositoryCloneUrlsResponse> {
            serializer = GetSourceRepositoryCloneUrlsOperationSerializer()
            deserializer = GetSourceRepositoryCloneUrlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSourceRepositoryCloneUrls"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSourceRepositoryCloneUrlsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSourceRepositoryCloneUrls-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about an space.
     */
    override suspend fun getSpace(input: GetSpaceRequest): GetSpaceResponse {
        val op = SdkHttpOperation.build<GetSpaceRequest, GetSpaceResponse> {
            serializer = GetSpaceOperationSerializer()
            deserializer = GetSpaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSpace"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSpaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSpace-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
     */
    override suspend fun getSubscription(input: GetSubscriptionRequest): GetSubscriptionResponse {
        val op = SdkHttpOperation.build<GetSubscriptionRequest, GetSubscriptionResponse> {
            serializer = GetSubscriptionOperationSerializer()
            deserializer = GetSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSubscription"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSubscriptionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSubscription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a user.
     */
    override suspend fun getUserDetails(input: GetUserDetailsRequest): GetUserDetailsResponse {
        val op = SdkHttpOperation.build<GetUserDetailsRequest, GetUserDetailsResponse> {
            serializer = GetUserDetailsOperationSerializer()
            deserializer = GetUserDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserDetails"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetUserDetailsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetUserDetails-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your user account.
     */
    override suspend fun listAccessTokens(input: ListAccessTokensRequest): ListAccessTokensResponse {
        val op = SdkHttpOperation.build<ListAccessTokensRequest, ListAccessTokensResponse> {
            serializer = ListAccessTokensOperationSerializer()
            deserializer = ListAccessTokensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccessTokens"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListAccessTokensRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAccessTokens-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrives a list of Dev Environments in a project.
     */
    override suspend fun listDevEnvironments(input: ListDevEnvironmentsRequest): ListDevEnvironmentsResponse {
        val op = SdkHttpOperation.build<ListDevEnvironmentsRequest, ListDevEnvironmentsResponse> {
            serializer = ListDevEnvironmentsOperationSerializer()
            deserializer = ListDevEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevEnvironments"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDevEnvironmentsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDevEnvironments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of events that occurred during a specified time period in a space. You can use these events to audit user and system activity in a space.
     */
    override suspend fun listEventLogs(input: ListEventLogsRequest): ListEventLogsResponse {
        val op = SdkHttpOperation.build<ListEventLogsRequest, ListEventLogsResponse> {
            serializer = ListEventLogsOperationSerializer()
            deserializer = ListEventLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventLogs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListEventLogsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEventLogs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of projects.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjects"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListProjectsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListProjects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of source repositories in a project.
     */
    override suspend fun listSourceRepositories(input: ListSourceRepositoriesRequest): ListSourceRepositoriesResponse {
        val op = SdkHttpOperation.build<ListSourceRepositoriesRequest, ListSourceRepositoriesResponse> {
            serializer = ListSourceRepositoriesOperationSerializer()
            deserializer = ListSourceRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSourceRepositories"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSourceRepositoriesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSourceRepositories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of branches in a specified source repository.
     */
    override suspend fun listSourceRepositoryBranches(input: ListSourceRepositoryBranchesRequest): ListSourceRepositoryBranchesResponse {
        val op = SdkHttpOperation.build<ListSourceRepositoryBranchesRequest, ListSourceRepositoryBranchesResponse> {
            serializer = ListSourceRepositoryBranchesOperationSerializer()
            deserializer = ListSourceRepositoryBranchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSourceRepositoryBranches"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSourceRepositoryBranchesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSourceRepositoryBranches-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of spaces.
     */
    override suspend fun listSpaces(input: ListSpacesRequest): ListSpacesResponse {
        val op = SdkHttpOperation.build<ListSpacesRequest, ListSpacesResponse> {
            serializer = ListSpacesOperationSerializer()
            deserializer = ListSpacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSpaces"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSpacesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSpaces-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a specified Dev Environment and puts it into an active state.
     */
    override suspend fun startDevEnvironment(input: StartDevEnvironmentRequest): StartDevEnvironmentResponse {
        val op = SdkHttpOperation.build<StartDevEnvironmentRequest, StartDevEnvironmentResponse> {
            serializer = StartDevEnvironmentOperationSerializer()
            deserializer = StartDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a session for a specified Dev Environment.
     */
    override suspend fun startDevEnvironmentSession(input: StartDevEnvironmentSessionRequest): StartDevEnvironmentSessionResponse {
        val op = SdkHttpOperation.build<StartDevEnvironmentSessionRequest, StartDevEnvironmentSessionResponse> {
            serializer = StartDevEnvironmentSessionOperationSerializer()
            deserializer = StartDevEnvironmentSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDevEnvironmentSession"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartDevEnvironmentSessionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartDevEnvironmentSession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
     */
    override suspend fun stopDevEnvironment(input: StopDevEnvironmentRequest): StopDevEnvironmentResponse {
        val op = SdkHttpOperation.build<StopDevEnvironmentRequest, StopDevEnvironmentResponse> {
            serializer = StopDevEnvironmentOperationSerializer()
            deserializer = StopDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StopDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
     */
    override suspend fun updateDevEnvironment(input: UpdateDevEnvironmentRequest): UpdateDevEnvironmentResponse {
        val op = SdkHttpOperation.build<UpdateDevEnvironmentRequest, UpdateDevEnvironmentResponse> {
            serializer = UpdateDevEnvironmentOperationSerializer()
            deserializer = UpdateDevEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDevEnvironment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDevEnvironmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDevEnvironment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
     */
    override suspend fun verifySession(input: VerifySessionRequest): VerifySessionResponse {
        val op = SdkHttpOperation.build<VerifySessionRequest, VerifySessionResponse> {
            serializer = VerifySessionOperationSerializer()
            deserializer = VerifySessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "VerifySession"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<VerifySessionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("VerifySession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
