// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.serde

import aws.sdk.kotlin.services.codebuild.model.Build
import aws.sdk.kotlin.services.codebuild.model.CodeBuildException
import aws.sdk.kotlin.services.codebuild.model.RetryBuildResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RetryBuildOperationDeserializer: HttpDeserializer.NonStreaming<RetryBuildResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RetryBuildResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRetryBuildError(context, call, payload)
        }
        val builder = RetryBuildResponse.Builder()

        if (payload != null) {
            deserializeRetryBuildOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRetryBuildError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeBuildException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccountLimitExceededException" -> AccountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeBuildException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRetryBuildOperationBody(builder: RetryBuildResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUILD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("build"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUILD_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUILD_DESCRIPTOR.index -> builder.build = deserializeBuildDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
