// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.serde

import aws.sdk.kotlin.services.codebuild.model.BatchGetReportsResponse
import aws.sdk.kotlin.services.codebuild.model.CodeBuildException
import aws.sdk.kotlin.services.codebuild.model.Report
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetReportsOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetReportsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetReportsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetReportsError(context, call, payload)
        }
        val builder = BatchGetReportsResponse.Builder()

        if (payload != null) {
            deserializeBatchGetReportsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetReportsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeBuildException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeBuildException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetReportsOperationBody(builder: BatchGetReportsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("reports"))
    val REPORTSNOTFOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("reportsNotFound"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPORTS_DESCRIPTOR)
        field(REPORTSNOTFOUND_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPORTS_DESCRIPTOR.index -> builder.reports =
                    deserializer.deserializeList(REPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Report>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReportDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REPORTSNOTFOUND_DESCRIPTOR.index -> builder.reportsNotFound =
                    deserializer.deserializeList(REPORTSNOTFOUND_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
