// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.serde

import aws.sdk.kotlin.services.codebuild.model.BatchGetFleetsResponse
import aws.sdk.kotlin.services.codebuild.model.CodeBuildException
import aws.sdk.kotlin.services.codebuild.model.Fleet
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetFleetsOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetFleetsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetFleetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetFleetsError(context, call, payload)
        }
        val builder = BatchGetFleetsResponse.Builder()

        if (payload != null) {
            deserializeBatchGetFleetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetFleetsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeBuildException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeBuildException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetFleetsOperationBody(builder: BatchGetFleetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("fleets"))
    val FLEETSNOTFOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("fleetsNotFound"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEETS_DESCRIPTOR)
        field(FLEETSNOTFOUND_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEETS_DESCRIPTOR.index -> builder.fleets =
                    deserializer.deserializeList(FLEETS_DESCRIPTOR) {
                        val col0 = mutableListOf<Fleet>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFleetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FLEETSNOTFOUND_DESCRIPTOR.index -> builder.fleetsNotFound =
                    deserializer.deserializeList(FLEETSNOTFOUND_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
