// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.serde

import aws.sdk.kotlin.services.codebuild.model.BatchGetBuildsResponse
import aws.sdk.kotlin.services.codebuild.model.Build
import aws.sdk.kotlin.services.codebuild.model.CodeBuildException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetBuildsOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetBuildsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetBuildsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetBuildsError(context, call, payload)
        }
        val builder = BatchGetBuildsResponse.Builder()

        if (payload != null) {
            deserializeBatchGetBuildsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetBuildsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeBuildException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeBuildException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetBuildsOperationBody(builder: BatchGetBuildsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUILDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("builds"))
    val BUILDSNOTFOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("buildsNotFound"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUILDS_DESCRIPTOR)
        field(BUILDSNOTFOUND_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUILDS_DESCRIPTOR.index -> builder.builds =
                    deserializer.deserializeList(BUILDS_DESCRIPTOR) {
                        val col0 = mutableListOf<Build>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBuildDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BUILDSNOTFOUND_DESCRIPTOR.index -> builder.buildsNotFound =
                    deserializer.deserializeList(BUILDSNOTFOUND_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
