// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter used to determine which webhooks trigger a build.
 */
public class WebhookFilter private constructor(builder: Builder) {
    /**
     * Used to indicate that the `pattern` determines which webhook events do not trigger a build. If true, then a webhook event that does not match the `pattern` triggers a build. If false, then a webhook event that matches the `pattern` triggers a build.
     */
    public val excludeMatchedPattern: kotlin.Boolean? = builder.excludeMatchedPattern
    /**
     * For a `WebHookFilter` that uses `EVENT` type, a comma-separated string that specifies one or more events. For example, the webhook filter `PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED` allows all push, pull request created, and pull request updated events to trigger a build.
     *
     *  For a `WebHookFilter` that uses any of the other filter types, a regular expression pattern. For example, a `WebHookFilter` that uses `HEAD_REF` for its `type` and the pattern `^refs/heads/` triggers a build when the head reference is a branch with a reference name `refs/heads/branch-name`.
     */
    public val pattern: kotlin.String = requireNotNull(builder.pattern) { "A non-null value must be provided for pattern" }
    /**
     * The type of webhook filter. There are nine webhook filter types: `EVENT`, `ACTOR_ACCOUNT_ID`, `HEAD_REF`, `BASE_REF`, `FILE_PATH`, `COMMIT_MESSAGE`, `TAG_NAME`, `RELEASE_NAME`, and `WORKFLOW_NAME`.
     * +  EVENT
     *    +  A webhook event triggers a build when the provided `pattern` matches one of nine event types: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_CLOSED`, `PULL_REQUEST_REOPENED`, `PULL_REQUEST_MERGED`, `RELEASED`, `PRERELEASED`, and `WORKFLOW_JOB_QUEUED`. The `EVENT` patterns are specified as a comma-separated string. For example, `PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED` filters all push, pull request created, and pull request updated events.  Types `PULL_REQUEST_REOPENED` and `WORKFLOW_JOB_QUEUED` work with GitHub and GitHub Enterprise only. Types `RELEASED` and `PRERELEASED` work with GitHub only.
     * + ACTOR_ACCOUNT_ID
     *    +  A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket account ID matches the regular expression `pattern`.
     * + HEAD_REF
     *    +  A webhook event triggers a build when the head reference matches the regular expression `pattern`. For example, `refs/heads/branch-name` and `refs/tags/tag-name`.  Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
     * + BASE_REF
     *    +  A webhook event triggers a build when the base reference matches the regular expression `pattern`. For example, `refs/heads/branch-name`.  Works with pull request events only.
     * + FILE_PATH
     *    +  A webhook triggers a build when the path of a changed file matches the regular expression `pattern`.  Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
     * + COMMIT_MESSAGE
     *    + A webhook triggers a build when the head commit message matches the regular expression `pattern`. Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
     * + TAG_NAME
     *    + A webhook triggers a build when the tag name of the release matches the regular expression `pattern`. Works with `RELEASED` and `PRERELEASED` events only.
     * + RELEASE_NAME
     *    + A webhook triggers a build when the release name matches the regular expression `pattern`. Works with `RELEASED` and `PRERELEASED` events only.
     * + REPOSITORY_NAME
     *    + A webhook triggers a build when the repository name matches the regular expression pattern. Works with GitHub global or organization webhooks only.
     * + WORKFLOW_NAME
     *    + A webhook triggers a build when the workflow name matches the regular expression `pattern`. Works with `WORKFLOW_JOB_QUEUED` events only.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.WebhookFilterType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.WebhookFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebhookFilter(")
        append("excludeMatchedPattern=$excludeMatchedPattern,")
        append("pattern=$pattern,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludeMatchedPattern?.hashCode() ?: 0
        result = 31 * result + (pattern.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebhookFilter

        if (excludeMatchedPattern != other.excludeMatchedPattern) return false
        if (pattern != other.pattern) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.WebhookFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Used to indicate that the `pattern` determines which webhook events do not trigger a build. If true, then a webhook event that does not match the `pattern` triggers a build. If false, then a webhook event that matches the `pattern` triggers a build.
         */
        public var excludeMatchedPattern: kotlin.Boolean? = null
        /**
         * For a `WebHookFilter` that uses `EVENT` type, a comma-separated string that specifies one or more events. For example, the webhook filter `PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED` allows all push, pull request created, and pull request updated events to trigger a build.
         *
         *  For a `WebHookFilter` that uses any of the other filter types, a regular expression pattern. For example, a `WebHookFilter` that uses `HEAD_REF` for its `type` and the pattern `^refs/heads/` triggers a build when the head reference is a branch with a reference name `refs/heads/branch-name`.
         */
        public var pattern: kotlin.String? = null
        /**
         * The type of webhook filter. There are nine webhook filter types: `EVENT`, `ACTOR_ACCOUNT_ID`, `HEAD_REF`, `BASE_REF`, `FILE_PATH`, `COMMIT_MESSAGE`, `TAG_NAME`, `RELEASE_NAME`, and `WORKFLOW_NAME`.
         * +  EVENT
         *    +  A webhook event triggers a build when the provided `pattern` matches one of nine event types: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_CLOSED`, `PULL_REQUEST_REOPENED`, `PULL_REQUEST_MERGED`, `RELEASED`, `PRERELEASED`, and `WORKFLOW_JOB_QUEUED`. The `EVENT` patterns are specified as a comma-separated string. For example, `PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED` filters all push, pull request created, and pull request updated events.  Types `PULL_REQUEST_REOPENED` and `WORKFLOW_JOB_QUEUED` work with GitHub and GitHub Enterprise only. Types `RELEASED` and `PRERELEASED` work with GitHub only.
         * + ACTOR_ACCOUNT_ID
         *    +  A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket account ID matches the regular expression `pattern`.
         * + HEAD_REF
         *    +  A webhook event triggers a build when the head reference matches the regular expression `pattern`. For example, `refs/heads/branch-name` and `refs/tags/tag-name`.  Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
         * + BASE_REF
         *    +  A webhook event triggers a build when the base reference matches the regular expression `pattern`. For example, `refs/heads/branch-name`.  Works with pull request events only.
         * + FILE_PATH
         *    +  A webhook triggers a build when the path of a changed file matches the regular expression `pattern`.  Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
         * + COMMIT_MESSAGE
         *    + A webhook triggers a build when the head commit message matches the regular expression `pattern`. Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
         * + TAG_NAME
         *    + A webhook triggers a build when the tag name of the release matches the regular expression `pattern`. Works with `RELEASED` and `PRERELEASED` events only.
         * + RELEASE_NAME
         *    + A webhook triggers a build when the release name matches the regular expression `pattern`. Works with `RELEASED` and `PRERELEASED` events only.
         * + REPOSITORY_NAME
         *    + A webhook triggers a build when the repository name matches the regular expression pattern. Works with GitHub global or organization webhooks only.
         * + WORKFLOW_NAME
         *    + A webhook triggers a build when the workflow name matches the regular expression `pattern`. Works with `WORKFLOW_JOB_QUEUED` events only.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.WebhookFilterType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.WebhookFilter) : this() {
            this.excludeMatchedPattern = x.excludeMatchedPattern
            this.pattern = x.pattern
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.WebhookFilter = WebhookFilter(this)

        internal fun correctErrors(): Builder {
            if (pattern == null) pattern = ""
            if (type == null) type = WebhookFilterType.SdkUnknown("no value provided")
            return this
        }
    }
}
