// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a webhook that connects repository events to a build project in CodeBuild.
 */
public class Webhook private constructor(builder: Builder) {
    /**
     * A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If `branchFilter` is empty, then all branches are built.
     *
     * It is recommended that you use `filterGroups` instead of `branchFilter`.
     */
    public val branchFilter: kotlin.String? = builder.branchFilter
    /**
     * Specifies the type of build this webhook will trigger.
     */
    public val buildType: aws.sdk.kotlin.services.codebuild.model.WebhookBuildType? = builder.buildType
    /**
     * An array of arrays of `WebhookFilter` objects used to determine which webhooks are triggered. At least one `WebhookFilter` in the array must specify `EVENT` as its `type`.
     *
     * For a build to be triggered, at least one filter group in the `filterGroups` array must pass. For a filter group to pass, each of its filters must pass.
     */
    public val filterGroups: List<List<WebhookFilter>>? = builder.filterGroups
    /**
     * A timestamp that indicates the last time a repository's secret token was modified.
     */
    public val lastModifiedSecret: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedSecret
    /**
     * If manualCreation is true, CodeBuild doesn't create a webhook in GitHub and instead returns `payloadUrl` and `secret` values for the webhook. The `payloadUrl` and `secret` values in the output can be used to manually create a webhook within GitHub.
     *
     * manualCreation is only available for GitHub webhooks.
     */
    public val manualCreation: kotlin.Boolean? = builder.manualCreation
    /**
     * The CodeBuild endpoint where webhook events are sent.
     */
    public val payloadUrl: kotlin.String? = builder.payloadUrl
    /**
     * The scope configuration for global or organization webhooks.
     *
     * Global or organization webhooks are only available for GitHub and Github Enterprise webhooks.
     */
    public val scopeConfiguration: aws.sdk.kotlin.services.codebuild.model.ScopeConfiguration? = builder.scopeConfiguration
    /**
     * The secret token of the associated repository.
     *
     * A Bitbucket webhook does not support `secret`.
     */
    public val secret: kotlin.String? = builder.secret
    /**
     * The URL to the webhook.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Webhook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Webhook(")
        append("branchFilter=$branchFilter,")
        append("buildType=$buildType,")
        append("filterGroups=$filterGroups,")
        append("lastModifiedSecret=$lastModifiedSecret,")
        append("manualCreation=$manualCreation,")
        append("payloadUrl=$payloadUrl,")
        append("scopeConfiguration=$scopeConfiguration,")
        append("secret=$secret,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchFilter?.hashCode() ?: 0
        result = 31 * result + (buildType?.hashCode() ?: 0)
        result = 31 * result + (filterGroups?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedSecret?.hashCode() ?: 0)
        result = 31 * result + (manualCreation?.hashCode() ?: 0)
        result = 31 * result + (payloadUrl?.hashCode() ?: 0)
        result = 31 * result + (scopeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secret?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Webhook

        if (branchFilter != other.branchFilter) return false
        if (buildType != other.buildType) return false
        if (filterGroups != other.filterGroups) return false
        if (lastModifiedSecret != other.lastModifiedSecret) return false
        if (manualCreation != other.manualCreation) return false
        if (payloadUrl != other.payloadUrl) return false
        if (scopeConfiguration != other.scopeConfiguration) return false
        if (secret != other.secret) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Webhook = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If `branchFilter` is empty, then all branches are built.
         *
         * It is recommended that you use `filterGroups` instead of `branchFilter`.
         */
        public var branchFilter: kotlin.String? = null
        /**
         * Specifies the type of build this webhook will trigger.
         */
        public var buildType: aws.sdk.kotlin.services.codebuild.model.WebhookBuildType? = null
        /**
         * An array of arrays of `WebhookFilter` objects used to determine which webhooks are triggered. At least one `WebhookFilter` in the array must specify `EVENT` as its `type`.
         *
         * For a build to be triggered, at least one filter group in the `filterGroups` array must pass. For a filter group to pass, each of its filters must pass.
         */
        public var filterGroups: List<List<WebhookFilter>>? = null
        /**
         * A timestamp that indicates the last time a repository's secret token was modified.
         */
        public var lastModifiedSecret: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If manualCreation is true, CodeBuild doesn't create a webhook in GitHub and instead returns `payloadUrl` and `secret` values for the webhook. The `payloadUrl` and `secret` values in the output can be used to manually create a webhook within GitHub.
         *
         * manualCreation is only available for GitHub webhooks.
         */
        public var manualCreation: kotlin.Boolean? = null
        /**
         * The CodeBuild endpoint where webhook events are sent.
         */
        public var payloadUrl: kotlin.String? = null
        /**
         * The scope configuration for global or organization webhooks.
         *
         * Global or organization webhooks are only available for GitHub and Github Enterprise webhooks.
         */
        public var scopeConfiguration: aws.sdk.kotlin.services.codebuild.model.ScopeConfiguration? = null
        /**
         * The secret token of the associated repository.
         *
         * A Bitbucket webhook does not support `secret`.
         */
        public var secret: kotlin.String? = null
        /**
         * The URL to the webhook.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Webhook) : this() {
            this.branchFilter = x.branchFilter
            this.buildType = x.buildType
            this.filterGroups = x.filterGroups
            this.lastModifiedSecret = x.lastModifiedSecret
            this.manualCreation = x.manualCreation
            this.payloadUrl = x.payloadUrl
            this.scopeConfiguration = x.scopeConfiguration
            this.secret = x.secret
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Webhook = Webhook(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ScopeConfiguration] inside the given [block]
         */
        public fun scopeConfiguration(block: aws.sdk.kotlin.services.codebuild.model.ScopeConfiguration.Builder.() -> kotlin.Unit) {
            this.scopeConfiguration = aws.sdk.kotlin.services.codebuild.model.ScopeConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
