// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the S3 bucket where the raw data of a report are exported.
 */
public class S3ReportExportConfig private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket where the raw data of a report are exported.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket that is owned by an account other than the account running the build.
     */
    public val bucketOwner: kotlin.String? = builder.bucketOwner
    /**
     * A boolean value that specifies if the results of a report are encrypted.
     */
    public val encryptionDisabled: kotlin.Boolean? = builder.encryptionDisabled
    /**
     * The encryption key for the report's encrypted raw data.
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The type of build output artifact to create. Valid values include:
     * + `NONE`: CodeBuild creates the raw data in the output bucket. This is the default if packaging is not specified.
     * + `ZIP`: CodeBuild creates a ZIP file with the raw data in the output bucket.
     */
    public val packaging: aws.sdk.kotlin.services.codebuild.model.ReportPackagingType? = builder.packaging
    /**
     * The path to the exported report's raw data results.
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.S3ReportExportConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ReportExportConfig(")
        append("bucket=$bucket,")
        append("bucketOwner=$bucketOwner,")
        append("encryptionDisabled=$encryptionDisabled,")
        append("encryptionKey=$encryptionKey,")
        append("packaging=$packaging,")
        append("path=$path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bucketOwner?.hashCode() ?: 0)
        result = 31 * result + (encryptionDisabled?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (packaging?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ReportExportConfig

        if (bucket != other.bucket) return false
        if (bucketOwner != other.bucketOwner) return false
        if (encryptionDisabled != other.encryptionDisabled) return false
        if (encryptionKey != other.encryptionKey) return false
        if (packaging != other.packaging) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.S3ReportExportConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the S3 bucket where the raw data of a report are exported.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket that is owned by an account other than the account running the build.
         */
        public var bucketOwner: kotlin.String? = null
        /**
         * A boolean value that specifies if the results of a report are encrypted.
         */
        public var encryptionDisabled: kotlin.Boolean? = null
        /**
         * The encryption key for the report's encrypted raw data.
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The type of build output artifact to create. Valid values include:
         * + `NONE`: CodeBuild creates the raw data in the output bucket. This is the default if packaging is not specified.
         * + `ZIP`: CodeBuild creates a ZIP file with the raw data in the output bucket.
         */
        public var packaging: aws.sdk.kotlin.services.codebuild.model.ReportPackagingType? = null
        /**
         * The path to the exported report's raw data results.
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.S3ReportExportConfig) : this() {
            this.bucket = x.bucket
            this.bucketOwner = x.bucketOwner
            this.encryptionDisabled = x.encryptionDisabled
            this.encryptionKey = x.encryptionKey
            this.packaging = x.packaging
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.S3ReportExportConfig = S3ReportExportConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
