// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A series of reports. Each report contains information about the results from running a series of test cases. You specify the test cases for a report group in the buildspec for a build project using one or more paths to the test case files.
 */
public class ReportGroup private constructor(builder: Builder) {
    /**
     * The ARN of the `ReportGroup`.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time this `ReportGroup` was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * Information about the destination where the raw data of this `ReportGroup` is exported.
     */
    public val exportConfig: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig? = builder.exportConfig
    /**
     * The date and time this `ReportGroup` was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The name of the `ReportGroup`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the report group. This property is read-only.
     *
     * This can be one of the following values:
     *
     * ## ACTIVE
     * The report group is active.
     *
     * ## DELETING
     * The report group is in the process of being deleted.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.ReportGroupStatusType? = builder.status
    /**
     * A list of tag key and value pairs associated with this report group.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of the `ReportGroup`. This can be one of the following values:
     *
     * ## CODE_COVERAGE
     * The report group contains code coverage reports.
     *
     * ## TEST
     * The report group contains test reports.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.ReportType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ReportGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportGroup(")
        append("arn=$arn,")
        append("created=$created,")
        append("exportConfig=$exportConfig,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (exportConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportGroup

        if (arn != other.arn) return false
        if (created != other.created) return false
        if (exportConfig != other.exportConfig) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ReportGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the `ReportGroup`.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time this `ReportGroup` was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the destination where the raw data of this `ReportGroup` is exported.
         */
        public var exportConfig: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig? = null
        /**
         * The date and time this `ReportGroup` was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the `ReportGroup`.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the report group. This property is read-only.
         *
         * This can be one of the following values:
         *
         * ## ACTIVE
         * The report group is active.
         *
         * ## DELETING
         * The report group is in the process of being deleted.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.ReportGroupStatusType? = null
        /**
         * A list of tag key and value pairs associated with this report group.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of the `ReportGroup`. This can be one of the following values:
         *
         * ## CODE_COVERAGE
         * The report group contains code coverage reports.
         *
         * ## TEST
         * The report group contains test reports.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.ReportType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ReportGroup) : this() {
            this.arn = x.arn
            this.created = x.created
            this.exportConfig = x.exportConfig
            this.lastModified = x.lastModified
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ReportGroup = ReportGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ReportExportConfig] inside the given [block]
         */
        public fun exportConfig(block: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig.Builder.() -> kotlin.Unit) {
            this.exportConfig = aws.sdk.kotlin.services.codebuild.model.ReportExportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
