// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the results from running a series of test cases during the run of a build project. The test cases are specified in the buildspec for the build project using one or more paths to the test case files. You can specify any type of tests you want, such as unit tests, integration tests, and functional tests.
 */
public class Report private constructor(builder: Builder) {
    /**
     * The ARN of the report run.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A `CodeCoverageReportSummary` object that contains a code coverage summary for this report.
     */
    public val codeCoverageSummary: aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary? = builder.codeCoverageSummary
    /**
     * The date and time this report run occurred.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The ARN of the build run that generated this report.
     */
    public val executionId: kotlin.String? = builder.executionId
    /**
     * The date and time a report expires. A report expires 30 days after it is created. An expired report is not available to view in CodeBuild.
     */
    public val expired: aws.smithy.kotlin.runtime.time.Instant? = builder.expired
    /**
     * Information about where the raw data used to generate this report was exported.
     */
    public val exportConfig: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig? = builder.exportConfig
    /**
     * The name of the report that was run.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the report group associated with this report.
     */
    public val reportGroupArn: kotlin.String? = builder.reportGroupArn
    /**
     * The status of this report.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.ReportStatusType? = builder.status
    /**
     * A `TestReportSummary` object that contains information about this test report.
     */
    public val testSummary: aws.sdk.kotlin.services.codebuild.model.TestReportSummary? = builder.testSummary
    /**
     * A boolean that specifies if this report run is truncated. The list of test cases is truncated after the maximum number of test cases is reached.
     */
    public val truncated: kotlin.Boolean? = builder.truncated
    /**
     * The type of the report that was run.
     *
     * ## CODE_COVERAGE
     * A code coverage report.
     *
     * ## TEST
     * A test report.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.ReportType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Report = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Report(")
        append("arn=$arn,")
        append("codeCoverageSummary=$codeCoverageSummary,")
        append("created=$created,")
        append("executionId=$executionId,")
        append("expired=$expired,")
        append("exportConfig=$exportConfig,")
        append("name=$name,")
        append("reportGroupArn=$reportGroupArn,")
        append("status=$status,")
        append("testSummary=$testSummary,")
        append("truncated=$truncated,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (codeCoverageSummary?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (executionId?.hashCode() ?: 0)
        result = 31 * result + (expired?.hashCode() ?: 0)
        result = 31 * result + (exportConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (reportGroupArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (testSummary?.hashCode() ?: 0)
        result = 31 * result + (truncated?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Report

        if (arn != other.arn) return false
        if (codeCoverageSummary != other.codeCoverageSummary) return false
        if (created != other.created) return false
        if (executionId != other.executionId) return false
        if (expired != other.expired) return false
        if (exportConfig != other.exportConfig) return false
        if (name != other.name) return false
        if (reportGroupArn != other.reportGroupArn) return false
        if (status != other.status) return false
        if (testSummary != other.testSummary) return false
        if (truncated != other.truncated) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Report = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the report run.
         */
        public var arn: kotlin.String? = null
        /**
         * A `CodeCoverageReportSummary` object that contains a code coverage summary for this report.
         */
        public var codeCoverageSummary: aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary? = null
        /**
         * The date and time this report run occurred.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the build run that generated this report.
         */
        public var executionId: kotlin.String? = null
        /**
         * The date and time a report expires. A report expires 30 days after it is created. An expired report is not available to view in CodeBuild.
         */
        public var expired: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about where the raw data used to generate this report was exported.
         */
        public var exportConfig: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig? = null
        /**
         * The name of the report that was run.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the report group associated with this report.
         */
        public var reportGroupArn: kotlin.String? = null
        /**
         * The status of this report.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.ReportStatusType? = null
        /**
         * A `TestReportSummary` object that contains information about this test report.
         */
        public var testSummary: aws.sdk.kotlin.services.codebuild.model.TestReportSummary? = null
        /**
         * A boolean that specifies if this report run is truncated. The list of test cases is truncated after the maximum number of test cases is reached.
         */
        public var truncated: kotlin.Boolean? = null
        /**
         * The type of the report that was run.
         *
         * ## CODE_COVERAGE
         * A code coverage report.
         *
         * ## TEST
         * A test report.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.ReportType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Report) : this() {
            this.arn = x.arn
            this.codeCoverageSummary = x.codeCoverageSummary
            this.created = x.created
            this.executionId = x.executionId
            this.expired = x.expired
            this.exportConfig = x.exportConfig
            this.name = x.name
            this.reportGroupArn = x.reportGroupArn
            this.status = x.status
            this.testSummary = x.testSummary
            this.truncated = x.truncated
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Report = Report(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary] inside the given [block]
         */
        public fun codeCoverageSummary(block: aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary.Builder.() -> kotlin.Unit) {
            this.codeCoverageSummary = aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ReportExportConfig] inside the given [block]
         */
        public fun exportConfig(block: aws.sdk.kotlin.services.codebuild.model.ReportExportConfig.Builder.() -> kotlin.Unit) {
            this.exportConfig = aws.sdk.kotlin.services.codebuild.model.ReportExportConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.TestReportSummary] inside the given [block]
         */
        public fun testSummary(block: aws.sdk.kotlin.services.codebuild.model.TestReportSummary.Builder.() -> kotlin.Unit) {
            this.testSummary = aws.sdk.kotlin.services.codebuild.model.TestReportSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
