// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A source identifier and its corresponding version.
 */
public class ProjectSourceVersion private constructor(builder: Builder) {
    /**
     * An identifier for a source in the build project. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     */
    public val sourceIdentifier: kotlin.String = requireNotNull(builder.sourceIdentifier) { "A non-null value must be provided for sourceIdentifier" }
    /**
     * The source version for the corresponding source identifier. If specified, must be one of:
     * + For CodeCommit: the commit ID, branch, or Git tag to use.
     * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For GitLab: the commit ID, branch, or Git tag to use.
     * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     *
     *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
     */
    public val sourceVersion: kotlin.String = requireNotNull(builder.sourceVersion) { "A non-null value must be provided for sourceVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectSourceVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectSourceVersion(")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceVersion=$sourceVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceIdentifier.hashCode()
        result = 31 * result + (sourceVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectSourceVersion

        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceVersion != other.sourceVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectSourceVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An identifier for a source in the build project. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         */
        public var sourceIdentifier: kotlin.String? = null
        /**
         * The source version for the corresponding source identifier. If specified, must be one of:
         * + For CodeCommit: the commit ID, branch, or Git tag to use.
         * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For GitLab: the commit ID, branch, or Git tag to use.
         * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         *
         *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
         */
        public var sourceVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectSourceVersion) : this() {
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceVersion = x.sourceVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectSourceVersion = ProjectSourceVersion(this)

        internal fun correctErrors(): Builder {
            if (sourceIdentifier == null) sourceIdentifier = ""
            if (sourceVersion == null) sourceVersion = ""
            return this
        }
    }
}
