// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the build input source code for the build project.
 */
public class ProjectSource private constructor(builder: Builder) {
    /**
     * Information about the authorization settings for CodeBuild to access the source code to be built.
     */
    public val auth: aws.sdk.kotlin.services.codebuild.model.SourceAuth? = builder.auth
    /**
     * Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
     */
    public val buildStatusConfig: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig? = builder.buildStatusConfig
    /**
     * The buildspec file declaration to use for the builds in this build project.
     *
     *  If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see [Buildspec File Name and Storage Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
     */
    public val buildspec: kotlin.String? = builder.buildspec
    /**
     * Information about the Git clone depth for the build project.
     */
    public val gitCloneDepth: kotlin.Int? = builder.gitCloneDepth
    /**
     * Information about the Git submodules configuration for the build project.
     */
    public val gitSubmodulesConfig: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig? = builder.gitSubmodulesConfig
    /**
     * Enable this flag to ignore SSL warnings while connecting to the project source code.
     */
    public val insecureSsl: kotlin.Boolean? = builder.insecureSsl
    /**
     * Information about the location of the source code to be built. Valid values include:
     * + For source code settings that are specified in the source action of a pipeline in CodePipeline, `location` should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.
     * + For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the buildspec file (for example, `https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name>`).
     * + For source code in an Amazon S3 input bucket, one of the following.
     *    + The path to the ZIP file that contains the source code (for example, `<bucket-name>/<path>/<object-name>.zip`).
     *    + The path to the folder that contains the source code (for example, `<bucket-name>/<path-to-source-code>/<folder>/`).
     * + For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your GitHub account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitHub, on the GitHub **Authorize application** page, for **Organization access**, choose **Request access** next to each repository you want to allow CodeBuild to have access to, and then choose **Authorize application**. (After you have connected to your GitHub account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to use this connection, in the `source` object, set the `auth` object's `type` value to `OAUTH`.
     * + For source code in an GitLab or self-managed GitLab repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your GitLab account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitLab, on the Connections **Authorize application** page, choose **Authorize**. Then on the CodeConnections **Create GitLab connection** page, choose **Connect to GitLab**. (After you have connected to your GitLab account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to override the default connection and use this connection instead, set the `auth` object's `type` value to `CODECONNECTIONS` in the `source` object.
     * + For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with Bitbucket, on the Bitbucket **Confirm access to your account** page, choose **Grant access**. (After you have connected to your Bitbucket account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to use this connection, in the `source` object, set the `auth` object's `type` value to `OAUTH`.
     *
     *  If you specify `CODEPIPELINE` for the `Type` property, don't specify this property. For all of the other types, you must specify `Location`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Set to true to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. If this is set and you use a different source provider, an `invalidInputException` is thrown.
     *
     * To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see [Source provider access](https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html) in the *CodeBuild User Guide*.
     *
     * The status of a build triggered by a webhook is always reported to your source provider.
     *
     * If your project's builds are triggered by a webhook, you must push a new commit to the repo for a change to this property to take effect.
     */
    public val reportBuildStatus: kotlin.Boolean? = builder.reportBuildStatus
    /**
     * An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     */
    public val sourceIdentifier: kotlin.String? = builder.sourceIdentifier
    /**
     * The type of repository that contains the source code to be built. Valid values include:
     * + `BITBUCKET`: The source code is in a Bitbucket repository.
     * + `CODECOMMIT`: The source code is in an CodeCommit repository.
     * + `CODEPIPELINE`: The source code settings are specified in the source action of a pipeline in CodePipeline.
     * + `GITHUB`: The source code is in a GitHub repository.
     * + `GITHUB_ENTERPRISE`: The source code is in a GitHub Enterprise Server repository.
     * + `GITLAB`: The source code is in a GitLab repository.
     * + `GITLAB_SELF_MANAGED`: The source code is in a self-managed GitLab repository.
     * + `NO_SOURCE`: The project does not have input source code.
     * + `S3`: The source code is in an Amazon S3 bucket.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.SourceType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectSource(")
        append("auth=$auth,")
        append("buildStatusConfig=$buildStatusConfig,")
        append("buildspec=$buildspec,")
        append("gitCloneDepth=$gitCloneDepth,")
        append("gitSubmodulesConfig=$gitSubmodulesConfig,")
        append("insecureSsl=$insecureSsl,")
        append("location=$location,")
        append("reportBuildStatus=$reportBuildStatus,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auth?.hashCode() ?: 0
        result = 31 * result + (buildStatusConfig?.hashCode() ?: 0)
        result = 31 * result + (buildspec?.hashCode() ?: 0)
        result = 31 * result + (gitCloneDepth ?: 0)
        result = 31 * result + (gitSubmodulesConfig?.hashCode() ?: 0)
        result = 31 * result + (insecureSsl?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (reportBuildStatus?.hashCode() ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectSource

        if (auth != other.auth) return false
        if (buildStatusConfig != other.buildStatusConfig) return false
        if (buildspec != other.buildspec) return false
        if (gitCloneDepth != other.gitCloneDepth) return false
        if (gitSubmodulesConfig != other.gitSubmodulesConfig) return false
        if (insecureSsl != other.insecureSsl) return false
        if (location != other.location) return false
        if (reportBuildStatus != other.reportBuildStatus) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the authorization settings for CodeBuild to access the source code to be built.
         */
        public var auth: aws.sdk.kotlin.services.codebuild.model.SourceAuth? = null
        /**
         * Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
         */
        public var buildStatusConfig: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig? = null
        /**
         * The buildspec file declaration to use for the builds in this build project.
         *
         *  If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see [Buildspec File Name and Storage Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
         */
        public var buildspec: kotlin.String? = null
        /**
         * Information about the Git clone depth for the build project.
         */
        public var gitCloneDepth: kotlin.Int? = null
        /**
         * Information about the Git submodules configuration for the build project.
         */
        public var gitSubmodulesConfig: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig? = null
        /**
         * Enable this flag to ignore SSL warnings while connecting to the project source code.
         */
        public var insecureSsl: kotlin.Boolean? = null
        /**
         * Information about the location of the source code to be built. Valid values include:
         * + For source code settings that are specified in the source action of a pipeline in CodePipeline, `location` should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.
         * + For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the buildspec file (for example, `https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name>`).
         * + For source code in an Amazon S3 input bucket, one of the following.
         *    + The path to the ZIP file that contains the source code (for example, `<bucket-name>/<path>/<object-name>.zip`).
         *    + The path to the folder that contains the source code (for example, `<bucket-name>/<path-to-source-code>/<folder>/`).
         * + For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your GitHub account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitHub, on the GitHub **Authorize application** page, for **Organization access**, choose **Request access** next to each repository you want to allow CodeBuild to have access to, and then choose **Authorize application**. (After you have connected to your GitHub account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to use this connection, in the `source` object, set the `auth` object's `type` value to `OAUTH`.
         * + For source code in an GitLab or self-managed GitLab repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your GitLab account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitLab, on the Connections **Authorize application** page, choose **Authorize**. Then on the CodeConnections **Create GitLab connection** page, choose **Connect to GitLab**. (After you have connected to your GitLab account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to override the default connection and use this connection instead, set the `auth` object's `type` value to `CODECONNECTIONS` in the `source` object.
         * + For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with Bitbucket, on the Bitbucket **Confirm access to your account** page, choose **Grant access**. (After you have connected to your Bitbucket account, you do not need to finish creating the build project. You can leave the CodeBuild console.) To instruct CodeBuild to use this connection, in the `source` object, set the `auth` object's `type` value to `OAUTH`.
         *
         *  If you specify `CODEPIPELINE` for the `Type` property, don't specify this property. For all of the other types, you must specify `Location`.
         */
        public var location: kotlin.String? = null
        /**
         * Set to true to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. If this is set and you use a different source provider, an `invalidInputException` is thrown.
         *
         * To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see [Source provider access](https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html) in the *CodeBuild User Guide*.
         *
         * The status of a build triggered by a webhook is always reported to your source provider.
         *
         * If your project's builds are triggered by a webhook, you must push a new commit to the repo for a change to this property to take effect.
         */
        public var reportBuildStatus: kotlin.Boolean? = null
        /**
         * An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         */
        public var sourceIdentifier: kotlin.String? = null
        /**
         * The type of repository that contains the source code to be built. Valid values include:
         * + `BITBUCKET`: The source code is in a Bitbucket repository.
         * + `CODECOMMIT`: The source code is in an CodeCommit repository.
         * + `CODEPIPELINE`: The source code settings are specified in the source action of a pipeline in CodePipeline.
         * + `GITHUB`: The source code is in a GitHub repository.
         * + `GITHUB_ENTERPRISE`: The source code is in a GitHub Enterprise Server repository.
         * + `GITLAB`: The source code is in a GitLab repository.
         * + `GITLAB_SELF_MANAGED`: The source code is in a self-managed GitLab repository.
         * + `NO_SOURCE`: The project does not have input source code.
         * + `S3`: The source code is in an Amazon S3 bucket.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectSource) : this() {
            this.auth = x.auth
            this.buildStatusConfig = x.buildStatusConfig
            this.buildspec = x.buildspec
            this.gitCloneDepth = x.gitCloneDepth
            this.gitSubmodulesConfig = x.gitSubmodulesConfig
            this.insecureSsl = x.insecureSsl
            this.location = x.location
            this.reportBuildStatus = x.reportBuildStatus
            this.sourceIdentifier = x.sourceIdentifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectSource = ProjectSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.SourceAuth] inside the given [block]
         */
        public fun auth(block: aws.sdk.kotlin.services.codebuild.model.SourceAuth.Builder.() -> kotlin.Unit) {
            this.auth = aws.sdk.kotlin.services.codebuild.model.SourceAuth.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig] inside the given [block]
         */
        public fun buildStatusConfig(block: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig.Builder.() -> kotlin.Unit) {
            this.buildStatusConfig = aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig] inside the given [block]
         */
        public fun gitSubmodulesConfig(block: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig.Builder.() -> kotlin.Unit) {
            this.gitSubmodulesConfig = aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (type == null) type = SourceType.SdkUnknown("no value provided")
            return this
        }
    }
}
