// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the build environment of the build project.
 */
public class ProjectEnvironment private constructor(builder: Builder) {
    /**
     * The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded certificate for the build project. For more information, see [certificate](https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate) in the *CodeBuild User Guide*.
     */
    public val certificate: kotlin.String? = builder.certificate
    /**
     * Information about the compute resources the build project uses. Available values include:
     * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
     * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
     * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
     * + `BUILD_LAMBDA_1GB`: Use up to 1 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
     * + `BUILD_LAMBDA_2GB`: Use up to 2 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
     * + `BUILD_LAMBDA_4GB`: Use up to 4 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
     * + `BUILD_LAMBDA_8GB`: Use up to 8 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
     * + `BUILD_LAMBDA_10GB`: Use up to 10 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
     *
     *  If you use `BUILD_GENERAL1_SMALL`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
     *
     *  If you use `BUILD_GENERAL1_LARGE`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
     *
     * If you're using compute fleets during project creation, `computeType` will be ignored.
     *
     * For more information, see [Build Environment Compute Types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
     */
    public val computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType = requireNotNull(builder.computeType) { "A non-null value must be provided for computeType" }
    /**
     * A set of environment variables to make available to builds for this build project.
     */
    public val environmentVariables: List<EnvironmentVariable>? = builder.environmentVariables
    /**
     * A ProjectFleet object to use for this build project.
     */
    public val fleet: aws.sdk.kotlin.services.codebuild.model.ProjectFleet? = builder.fleet
    /**
     * The image tag or image digest that identifies the Docker image to use for this build project. Use the following formats:
     * + For an image tag: `<registry>/<repository>:<tag>`. For example, in the Docker repository that CodeBuild uses to manage its Docker images, this would be `aws/codebuild/standard:4.0`.
     * + For an image digest: `<registry>/<repository>@<digest>`. For example, to specify an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use `<registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf`.
     *
     * For more information, see [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) in the *CodeBuild user guide*.
     */
    public val image: kotlin.String = requireNotNull(builder.image) { "A non-null value must be provided for image" }
    /**
     * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
     * + `CODEBUILD` specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild service principal.
     * + `SERVICE_ROLE` specifies that CodeBuild uses your build project's service role.
     *
     *  When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
     */
    public val imagePullCredentialsType: aws.sdk.kotlin.services.codebuild.model.ImagePullCredentialsType? = builder.imagePullCredentialsType
    /**
     * Enables running the Docker daemon inside a Docker container. Set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. The default setting is `false`.
     *
     * You can initialize the Docker daemon during the install phase of your build by adding one of the following sets of commands to the install phase of your buildspec file:
     *
     * If the operating system's base image is Ubuntu Linux:
     *
     * `- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&`
     *
     * `- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"`
     *
     * If the operating system's base image is Alpine Linux and the previous command does not work, add the `-t` argument to `timeout`:
     *
     * `- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&`
     *
     * `- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"`
     */
    public val privilegedMode: kotlin.Boolean? = builder.privilegedMode
    /**
     * The credentials for access to a private registry.
     */
    public val registryCredential: aws.sdk.kotlin.services.codebuild.model.RegistryCredential? = builder.registryCredential
    /**
     * The type of build environment to use for related builds.
     * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and EU (Frankfurt).
     * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
     * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and China (Ningxia).
     *
     * + The environment types `ARM_LAMBDA_CONTAINER` and `LINUX_LAMBDA_CONTAINER` are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Mumbai), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), EU (Frankfurt), EU (Ireland), and South America (São Paulo).
     *
     * + The environment types `WINDOWS_CONTAINER` and `WINDOWS_SERVER_2019_CONTAINER` are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and EU (Ireland).
     *
     * If you're using compute fleets during project creation, `type` will be ignored.
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.EnvironmentType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectEnvironment(")
        append("certificate=$certificate,")
        append("computeType=$computeType,")
        append("environmentVariables=$environmentVariables,")
        append("fleet=$fleet,")
        append("image=$image,")
        append("imagePullCredentialsType=$imagePullCredentialsType,")
        append("privilegedMode=$privilegedMode,")
        append("registryCredential=$registryCredential,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (computeType.hashCode())
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (fleet?.hashCode() ?: 0)
        result = 31 * result + (image.hashCode())
        result = 31 * result + (imagePullCredentialsType?.hashCode() ?: 0)
        result = 31 * result + (privilegedMode?.hashCode() ?: 0)
        result = 31 * result + (registryCredential?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectEnvironment

        if (certificate != other.certificate) return false
        if (computeType != other.computeType) return false
        if (environmentVariables != other.environmentVariables) return false
        if (fleet != other.fleet) return false
        if (image != other.image) return false
        if (imagePullCredentialsType != other.imagePullCredentialsType) return false
        if (privilegedMode != other.privilegedMode) return false
        if (registryCredential != other.registryCredential) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded certificate for the build project. For more information, see [certificate](https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate) in the *CodeBuild User Guide*.
         */
        public var certificate: kotlin.String? = null
        /**
         * Information about the compute resources the build project uses. Available values include:
         * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
         * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
         * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
         * + `BUILD_LAMBDA_1GB`: Use up to 1 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
         * + `BUILD_LAMBDA_2GB`: Use up to 2 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
         * + `BUILD_LAMBDA_4GB`: Use up to 4 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
         * + `BUILD_LAMBDA_8GB`: Use up to 8 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
         * + `BUILD_LAMBDA_10GB`: Use up to 10 GB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER`.
         *
         *  If you use `BUILD_GENERAL1_SMALL`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
         *
         *  If you use `BUILD_GENERAL1_LARGE`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
         *
         * If you're using compute fleets during project creation, `computeType` will be ignored.
         *
         * For more information, see [Build Environment Compute Types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
         */
        public var computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = null
        /**
         * A set of environment variables to make available to builds for this build project.
         */
        public var environmentVariables: List<EnvironmentVariable>? = null
        /**
         * A ProjectFleet object to use for this build project.
         */
        public var fleet: aws.sdk.kotlin.services.codebuild.model.ProjectFleet? = null
        /**
         * The image tag or image digest that identifies the Docker image to use for this build project. Use the following formats:
         * + For an image tag: `<registry>/<repository>:<tag>`. For example, in the Docker repository that CodeBuild uses to manage its Docker images, this would be `aws/codebuild/standard:4.0`.
         * + For an image digest: `<registry>/<repository>@<digest>`. For example, to specify an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use `<registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf`.
         *
         * For more information, see [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) in the *CodeBuild user guide*.
         */
        public var image: kotlin.String? = null
        /**
         * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
         * + `CODEBUILD` specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild service principal.
         * + `SERVICE_ROLE` specifies that CodeBuild uses your build project's service role.
         *
         *  When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
         */
        public var imagePullCredentialsType: aws.sdk.kotlin.services.codebuild.model.ImagePullCredentialsType? = null
        /**
         * Enables running the Docker daemon inside a Docker container. Set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. The default setting is `false`.
         *
         * You can initialize the Docker daemon during the install phase of your build by adding one of the following sets of commands to the install phase of your buildspec file:
         *
         * If the operating system's base image is Ubuntu Linux:
         *
         * `- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&`
         *
         * `- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"`
         *
         * If the operating system's base image is Alpine Linux and the previous command does not work, add the `-t` argument to `timeout`:
         *
         * `- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&`
         *
         * `- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"`
         */
        public var privilegedMode: kotlin.Boolean? = null
        /**
         * The credentials for access to a private registry.
         */
        public var registryCredential: aws.sdk.kotlin.services.codebuild.model.RegistryCredential? = null
        /**
         * The type of build environment to use for related builds.
         * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and EU (Frankfurt).
         * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and China (Ningxia).
         *
         * + The environment types `ARM_LAMBDA_CONTAINER` and `LINUX_LAMBDA_CONTAINER` are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Mumbai), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), EU (Frankfurt), EU (Ireland), and South America (São Paulo).
         *
         * + The environment types `WINDOWS_CONTAINER` and `WINDOWS_SERVER_2019_CONTAINER` are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and EU (Ireland).
         *
         * If you're using compute fleets during project creation, `type` will be ignored.
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment) : this() {
            this.certificate = x.certificate
            this.computeType = x.computeType
            this.environmentVariables = x.environmentVariables
            this.fleet = x.fleet
            this.image = x.image
            this.imagePullCredentialsType = x.imagePullCredentialsType
            this.privilegedMode = x.privilegedMode
            this.registryCredential = x.registryCredential
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment = ProjectEnvironment(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectFleet] inside the given [block]
         */
        public fun fleet(block: aws.sdk.kotlin.services.codebuild.model.ProjectFleet.Builder.() -> kotlin.Unit) {
            this.fleet = aws.sdk.kotlin.services.codebuild.model.ProjectFleet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.RegistryCredential] inside the given [block]
         */
        public fun registryCredential(block: aws.sdk.kotlin.services.codebuild.model.RegistryCredential.Builder.() -> kotlin.Unit) {
            this.registryCredential = aws.sdk.kotlin.services.codebuild.model.RegistryCredential.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (computeType == null) computeType = ComputeType.SdkUnknown("no value provided")
            if (image == null) image = ""
            if (type == null) type = EnvironmentType.SdkUnknown("no value provided")
            return this
        }
    }
}
