// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the cache for the build project.
 */
public class ProjectCache private constructor(builder: Builder) {
    /**
     * Information about the cache location:
     * + `NO_CACHE` or `LOCAL`: This value is ignored.
     * + `S3`: This is the S3 bucket name/prefix.
     */
    public val location: kotlin.String? = builder.location
    /**
     * An array of strings that specify the local cache modes. You can use one or more local cache modes at the same time. This is only used for `LOCAL` cache types.
     *
     * Possible values are:
     *
     * ## LOCAL_SOURCE_CACHE
     * Caches Git metadata for primary and secondary sources. After the cache is created, subsequent builds pull only the change between commits. This mode is a good choice for projects with a clean working directory and a source that is a large Git repository. If you choose this option and your project does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the option is ignored.
     *
     * ## LOCAL_DOCKER_LAYER_CACHE
     * Caches existing Docker layers. This mode is a good choice for projects that build or pull large Docker images. It can prevent the performance issues caused by pulling large Docker images down from the network.
     *
     * + You can use a Docker layer cache in the Linux environment only.
     * + The `privileged` flag must be set so that your project has the required Docker permissions.
     * + You should consider the security implications before you use a Docker layer cache.
     *
     * ## LOCAL_CUSTOM_CACHE
     * Caches directories you specify in the buildspec file. This mode is a good choice if your build scenario is not suited to one of the other three local cache modes. If you use a custom cache:
     * + Only directories can be specified for caching. You cannot specify individual files.
     * + Symlinks are used to reference cached directories.
     * + Cached directories are linked to your build before it downloads its project sources. Cached items are overridden if a source item has the same name. Directories are specified using cache paths in the buildspec file.
     */
    public val modes: List<CacheMode>? = builder.modes
    /**
     * The type of cache used by the build project. Valid values include:
     * + `NO_CACHE`: The build project does not use any cache.
     * + `S3`: The build project reads and writes from and to S3.
     * + `LOCAL`: The build project stores a cache locally on a build host that is only available to that build host.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.CacheType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectCache = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectCache(")
        append("location=$location,")
        append("modes=$modes,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = location?.hashCode() ?: 0
        result = 31 * result + (modes?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectCache

        if (location != other.location) return false
        if (modes != other.modes) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectCache = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the cache location:
         * + `NO_CACHE` or `LOCAL`: This value is ignored.
         * + `S3`: This is the S3 bucket name/prefix.
         */
        public var location: kotlin.String? = null
        /**
         * An array of strings that specify the local cache modes. You can use one or more local cache modes at the same time. This is only used for `LOCAL` cache types.
         *
         * Possible values are:
         *
         * ## LOCAL_SOURCE_CACHE
         * Caches Git metadata for primary and secondary sources. After the cache is created, subsequent builds pull only the change between commits. This mode is a good choice for projects with a clean working directory and a source that is a large Git repository. If you choose this option and your project does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the option is ignored.
         *
         * ## LOCAL_DOCKER_LAYER_CACHE
         * Caches existing Docker layers. This mode is a good choice for projects that build or pull large Docker images. It can prevent the performance issues caused by pulling large Docker images down from the network.
         *
         * + You can use a Docker layer cache in the Linux environment only.
         * + The `privileged` flag must be set so that your project has the required Docker permissions.
         * + You should consider the security implications before you use a Docker layer cache.
         *
         * ## LOCAL_CUSTOM_CACHE
         * Caches directories you specify in the buildspec file. This mode is a good choice if your build scenario is not suited to one of the other three local cache modes. If you use a custom cache:
         * + Only directories can be specified for caching. You cannot specify individual files.
         * + Symlinks are used to reference cached directories.
         * + Cached directories are linked to your build before it downloads its project sources. Cached items are overridden if a source item has the same name. Directories are specified using cache paths in the buildspec file.
         */
        public var modes: List<CacheMode>? = null
        /**
         * The type of cache used by the build project. Valid values include:
         * + `NO_CACHE`: The build project does not use any cache.
         * + `S3`: The build project reads and writes from and to S3.
         * + `LOCAL`: The build project stores a cache locally on a build host that is only available to that build host.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.CacheType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectCache) : this() {
            this.location = x.location
            this.modes = x.modes
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectCache = ProjectCache(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = CacheType.SdkUnknown("no value provided")
            return this
        }
    }
}
