// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a build project.
 */
public class Project private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the build project.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Information about the build output artifacts for the build project.
     */
    public val artifacts: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = builder.artifacts
    /**
     * Information about the build badge for the build project.
     */
    public val badge: aws.sdk.kotlin.services.codebuild.model.ProjectBadge? = builder.badge
    /**
     * A ProjectBuildBatchConfig object that defines the batch build options for the project.
     */
    public val buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = builder.buildBatchConfig
    /**
     * Information about the cache for the build project.
     */
    public val cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = builder.cache
    /**
     * The maximum number of concurrent builds that are allowed for this project.
     *
     * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
     */
    public val concurrentBuildLimit: kotlin.Int? = builder.concurrentBuildLimit
    /**
     * When the build project was created, expressed in Unix time format.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * A description that makes the build project easy to identify.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     *
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     *
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`). If you don't specify a value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * Information about the build environment for this build project.
     */
    public val environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = builder.environment
    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
     */
    public val fileSystemLocations: List<ProjectFileSystemLocation>? = builder.fileSystemLocations
    /**
     * When the build project's settings were last modified, expressed in Unix time format.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket, or both.
     */
    public val logsConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = builder.logsConfig
    /**
     * The name of the build project.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the visibility of the project's builds. Possible values are:
     *
     * ## PUBLIC_READ
     * The project builds are visible to the public.
     *
     * ## PRIVATE
     * The project builds are not visible to the public.
     */
    public val projectVisibility: aws.sdk.kotlin.services.codebuild.model.ProjectVisibilityType? = builder.projectVisibility
    /**
     * Contains the project identifier used with the public build APIs.
     */
    public val publicProjectAlias: kotlin.String? = builder.publicProjectAlias
    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    public val queuedTimeoutInMinutes: kotlin.Int? = builder.queuedTimeoutInMinutes
    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    public val resourceAccessRole: kotlin.String? = builder.resourceAccessRole
    /**
     * An array of `ProjectArtifacts` objects.
     */
    public val secondaryArtifacts: List<ProjectArtifacts>? = builder.secondaryArtifacts
    /**
     * An array of `ProjectSourceVersion` objects. If `secondarySourceVersions` is specified at the build level, then they take over these `secondarySourceVersions` (at the project level).
     */
    public val secondarySourceVersions: List<ProjectSourceVersion>? = builder.secondarySourceVersions
    /**
     * An array of `ProjectSource` objects.
     */
    public val secondarySources: List<ProjectSource>? = builder.secondarySources
    /**
     * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Information about the build input source code for this build project.
     */
    public val source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = builder.source
    /**
     * A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:
     * + For CodeCommit: the commit ID, branch, or Git tag to use.
     * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For GitLab: the commit ID, branch, or Git tag to use.
     * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     *
     * If `sourceVersion` is specified at the build level, then that version takes precedence over this `sourceVersion` (at the project level).
     *
     * For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion
    /**
     * A list of tag key and value pairs associated with this build project.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed. The default is 60 minutes.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes
    /**
     * Information about the VPC configuration that CodeBuild accesses.
     */
    public val vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = builder.vpcConfig
    /**
     * Information about a webhook that connects repository events to a build project in CodeBuild.
     */
    public val webhook: aws.sdk.kotlin.services.codebuild.model.Webhook? = builder.webhook

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Project = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Project(")
        append("arn=$arn,")
        append("artifacts=$artifacts,")
        append("badge=$badge,")
        append("buildBatchConfig=$buildBatchConfig,")
        append("cache=$cache,")
        append("concurrentBuildLimit=$concurrentBuildLimit,")
        append("created=$created,")
        append("description=$description,")
        append("encryptionKey=$encryptionKey,")
        append("environment=$environment,")
        append("fileSystemLocations=$fileSystemLocations,")
        append("lastModified=$lastModified,")
        append("logsConfig=$logsConfig,")
        append("name=$name,")
        append("projectVisibility=$projectVisibility,")
        append("publicProjectAlias=$publicProjectAlias,")
        append("queuedTimeoutInMinutes=$queuedTimeoutInMinutes,")
        append("resourceAccessRole=$resourceAccessRole,")
        append("secondaryArtifacts=$secondaryArtifacts,")
        append("secondarySourceVersions=$secondarySourceVersions,")
        append("secondarySources=$secondarySources,")
        append("serviceRole=$serviceRole,")
        append("source=$source,")
        append("sourceVersion=$sourceVersion,")
        append("tags=$tags,")
        append("timeoutInMinutes=$timeoutInMinutes,")
        append("vpcConfig=$vpcConfig,")
        append("webhook=$webhook")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (artifacts?.hashCode() ?: 0)
        result = 31 * result + (badge?.hashCode() ?: 0)
        result = 31 * result + (buildBatchConfig?.hashCode() ?: 0)
        result = 31 * result + (cache?.hashCode() ?: 0)
        result = 31 * result + (concurrentBuildLimit ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (fileSystemLocations?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (logsConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (projectVisibility?.hashCode() ?: 0)
        result = 31 * result + (publicProjectAlias?.hashCode() ?: 0)
        result = 31 * result + (queuedTimeoutInMinutes ?: 0)
        result = 31 * result + (resourceAccessRole?.hashCode() ?: 0)
        result = 31 * result + (secondaryArtifacts?.hashCode() ?: 0)
        result = 31 * result + (secondarySourceVersions?.hashCode() ?: 0)
        result = 31 * result + (secondarySources?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        result = 31 * result + (webhook?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Project

        if (arn != other.arn) return false
        if (artifacts != other.artifacts) return false
        if (badge != other.badge) return false
        if (buildBatchConfig != other.buildBatchConfig) return false
        if (cache != other.cache) return false
        if (concurrentBuildLimit != other.concurrentBuildLimit) return false
        if (created != other.created) return false
        if (description != other.description) return false
        if (encryptionKey != other.encryptionKey) return false
        if (environment != other.environment) return false
        if (fileSystemLocations != other.fileSystemLocations) return false
        if (lastModified != other.lastModified) return false
        if (logsConfig != other.logsConfig) return false
        if (name != other.name) return false
        if (projectVisibility != other.projectVisibility) return false
        if (publicProjectAlias != other.publicProjectAlias) return false
        if (queuedTimeoutInMinutes != other.queuedTimeoutInMinutes) return false
        if (resourceAccessRole != other.resourceAccessRole) return false
        if (secondaryArtifacts != other.secondaryArtifacts) return false
        if (secondarySourceVersions != other.secondarySourceVersions) return false
        if (secondarySources != other.secondarySources) return false
        if (serviceRole != other.serviceRole) return false
        if (source != other.source) return false
        if (sourceVersion != other.sourceVersion) return false
        if (tags != other.tags) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false
        if (vpcConfig != other.vpcConfig) return false
        if (webhook != other.webhook) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Project = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the build project.
         */
        public var arn: kotlin.String? = null
        /**
         * Information about the build output artifacts for the build project.
         */
        public var artifacts: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = null
        /**
         * Information about the build badge for the build project.
         */
        public var badge: aws.sdk.kotlin.services.codebuild.model.ProjectBadge? = null
        /**
         * A ProjectBuildBatchConfig object that defines the batch build options for the project.
         */
        public var buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = null
        /**
         * Information about the cache for the build project.
         */
        public var cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = null
        /**
         * The maximum number of concurrent builds that are allowed for this project.
         *
         * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
         */
        public var concurrentBuildLimit: kotlin.Int? = null
        /**
         * When the build project was created, expressed in Unix time format.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description that makes the build project easy to identify.
         */
        public var description: kotlin.String? = null
        /**
         * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
         *
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         *
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`). If you don't specify a value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * Information about the build environment for this build project.
         */
        public var environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = null
        /**
         * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
         */
        public var fileSystemLocations: List<ProjectFileSystemLocation>? = null
        /**
         * When the build project's settings were last modified, expressed in Unix time format.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket, or both.
         */
        public var logsConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = null
        /**
         * The name of the build project.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the visibility of the project's builds. Possible values are:
         *
         * ## PUBLIC_READ
         * The project builds are visible to the public.
         *
         * ## PRIVATE
         * The project builds are not visible to the public.
         */
        public var projectVisibility: aws.sdk.kotlin.services.codebuild.model.ProjectVisibilityType? = null
        /**
         * Contains the project identifier used with the public build APIs.
         */
        public var publicProjectAlias: kotlin.String? = null
        /**
         * The number of minutes a build is allowed to be queued before it times out.
         */
        public var queuedTimeoutInMinutes: kotlin.Int? = null
        /**
         * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
         */
        public var resourceAccessRole: kotlin.String? = null
        /**
         * An array of `ProjectArtifacts` objects.
         */
        public var secondaryArtifacts: List<ProjectArtifacts>? = null
        /**
         * An array of `ProjectSourceVersion` objects. If `secondarySourceVersions` is specified at the build level, then they take over these `secondarySourceVersions` (at the project level).
         */
        public var secondarySourceVersions: List<ProjectSourceVersion>? = null
        /**
         * An array of `ProjectSource` objects.
         */
        public var secondarySources: List<ProjectSource>? = null
        /**
         * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Information about the build input source code for this build project.
         */
        public var source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = null
        /**
         * A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:
         * + For CodeCommit: the commit ID, branch, or Git tag to use.
         * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For GitLab: the commit ID, branch, or Git tag to use.
         * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         *
         * If `sourceVersion` is specified at the build level, then that version takes precedence over this `sourceVersion` (at the project level).
         *
         * For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
         */
        public var sourceVersion: kotlin.String? = null
        /**
         * A list of tag key and value pairs associated with this build project.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         */
        public var tags: List<Tag>? = null
        /**
         * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed. The default is 60 minutes.
         */
        public var timeoutInMinutes: kotlin.Int? = null
        /**
         * Information about the VPC configuration that CodeBuild accesses.
         */
        public var vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = null
        /**
         * Information about a webhook that connects repository events to a build project in CodeBuild.
         */
        public var webhook: aws.sdk.kotlin.services.codebuild.model.Webhook? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Project) : this() {
            this.arn = x.arn
            this.artifacts = x.artifacts
            this.badge = x.badge
            this.buildBatchConfig = x.buildBatchConfig
            this.cache = x.cache
            this.concurrentBuildLimit = x.concurrentBuildLimit
            this.created = x.created
            this.description = x.description
            this.encryptionKey = x.encryptionKey
            this.environment = x.environment
            this.fileSystemLocations = x.fileSystemLocations
            this.lastModified = x.lastModified
            this.logsConfig = x.logsConfig
            this.name = x.name
            this.projectVisibility = x.projectVisibility
            this.publicProjectAlias = x.publicProjectAlias
            this.queuedTimeoutInMinutes = x.queuedTimeoutInMinutes
            this.resourceAccessRole = x.resourceAccessRole
            this.secondaryArtifacts = x.secondaryArtifacts
            this.secondarySourceVersions = x.secondarySourceVersions
            this.secondarySources = x.secondarySources
            this.serviceRole = x.serviceRole
            this.source = x.source
            this.sourceVersion = x.sourceVersion
            this.tags = x.tags
            this.timeoutInMinutes = x.timeoutInMinutes
            this.vpcConfig = x.vpcConfig
            this.webhook = x.webhook
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Project = Project(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts] inside the given [block]
         */
        public fun artifacts(block: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.Builder.() -> kotlin.Unit) {
            this.artifacts = aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectBadge] inside the given [block]
         */
        public fun badge(block: aws.sdk.kotlin.services.codebuild.model.ProjectBadge.Builder.() -> kotlin.Unit) {
            this.badge = aws.sdk.kotlin.services.codebuild.model.ProjectBadge.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig] inside the given [block]
         */
        public fun buildBatchConfig(block: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.Builder.() -> kotlin.Unit) {
            this.buildBatchConfig = aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectCache] inside the given [block]
         */
        public fun cache(block: aws.sdk.kotlin.services.codebuild.model.ProjectCache.Builder.() -> kotlin.Unit) {
            this.cache = aws.sdk.kotlin.services.codebuild.model.ProjectCache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.LogsConfig] inside the given [block]
         */
        public fun logsConfig(block: aws.sdk.kotlin.services.codebuild.model.LogsConfig.Builder.() -> kotlin.Unit) {
            this.logsConfig = aws.sdk.kotlin.services.codebuild.model.LogsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.codebuild.model.ProjectSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codebuild.model.ProjectSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.codebuild.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.codebuild.model.VpcConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.Webhook] inside the given [block]
         */
        public fun webhook(block: aws.sdk.kotlin.services.codebuild.model.Webhook.Builder.() -> kotlin.Unit) {
            this.webhook = aws.sdk.kotlin.services.codebuild.model.Webhook.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
