// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListReportsRequest private constructor(builder: Builder) {
    /**
     * A `ReportFilter` object used to filter the returned reports.
     */
    public val filter: aws.sdk.kotlin.services.codebuild.model.ReportFilter? = builder.filter
    /**
     * The maximum number of paginated reports returned per response. Use `nextToken` to iterate pages in the list of returned `Report` objects. The default value is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * During a previous call, the maximum number of items that can be returned is the value specified in `maxResults`. If there more items in the list, then a unique string called a *nextToken* is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the sort order for the list of returned reports. Valid values are:
     * + `ASCENDING`: return reports in chronological order based on their creation date.
     * + `DESCENDING`: return reports in the reverse chronological order based on their creation date.
     */
    public val sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ListReportsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListReportsRequest(")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListReportsRequest

        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ListReportsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A `ReportFilter` object used to filter the returned reports.
         */
        public var filter: aws.sdk.kotlin.services.codebuild.model.ReportFilter? = null
        /**
         * The maximum number of paginated reports returned per response. Use `nextToken` to iterate pages in the list of returned `Report` objects. The default value is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * During a previous call, the maximum number of items that can be returned is the value specified in `maxResults`. If there more items in the list, then a unique string called a *nextToken* is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the sort order for the list of returned reports. Valid values are:
         * + `ASCENDING`: return reports in chronological order based on their creation date.
         * + `DESCENDING`: return reports in the reverse chronological order based on their creation date.
         */
        public var sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ListReportsRequest) : this() {
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ListReportsRequest = ListReportsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ReportFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.codebuild.model.ReportFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.codebuild.model.ReportFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
