// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListFleetsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of paginated compute fleets returned per response. Use `nextToken` to iterate pages in the list of returned compute fleets.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a *nextToken*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The criterion to be used to list compute fleet names. Valid values include:
     * + `CREATED_TIME`: List based on when each compute fleet was created.
     * + `LAST_MODIFIED_TIME`: List based on when information about each compute fleet was last changed.
     * + `NAME`: List based on each compute fleet's name.
     *
     * Use `sortOrder` to specify in what order to list the compute fleet names based on the preceding criteria.
     */
    public val sortBy: aws.sdk.kotlin.services.codebuild.model.FleetSortByType? = builder.sortBy
    /**
     * The order in which to list compute fleets. Valid values include:
     * + `ASCENDING`: List in ascending order.
     * + `DESCENDING`: List in descending order.
     *
     * Use `sortBy` to specify the criterion to be used to list compute fleet names.
     */
    public val sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ListFleetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFleetsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=*** Sensitive Data Redacted ***,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFleetsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ListFleetsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of paginated compute fleets returned per response. Use `nextToken` to iterate pages in the list of returned compute fleets.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a *nextToken*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The criterion to be used to list compute fleet names. Valid values include:
         * + `CREATED_TIME`: List based on when each compute fleet was created.
         * + `LAST_MODIFIED_TIME`: List based on when information about each compute fleet was last changed.
         * + `NAME`: List based on each compute fleet's name.
         *
         * Use `sortOrder` to specify in what order to list the compute fleet names based on the preceding criteria.
         */
        public var sortBy: aws.sdk.kotlin.services.codebuild.model.FleetSortByType? = null
        /**
         * The order in which to list compute fleets. Valid values include:
         * + `ASCENDING`: List in ascending order.
         * + `DESCENDING`: List in descending order.
         *
         * Use `sortBy` to specify the criterion to be used to list compute fleet names.
         */
        public var sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ListFleetsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ListFleetsRequest = ListFleetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
