// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListBuildsForProjectRequest private constructor(builder: Builder) {
    /**
     * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a *nextToken*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the CodeBuild project.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * The order to sort the results in. The results are sorted by build number, not the build identifier. If this is not specified, the results are sorted in descending order.
     *
     * Valid values include:
     * + `ASCENDING`: List the build identifiers in ascending order, by build number.
     * + `DESCENDING`: List the build identifiers in descending order, by build number.
     *
     * If the project has more than 100 builds, setting the sort order will result in an error.
     */
    public val sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBuildsForProjectRequest(")
        append("nextToken=$nextToken,")
        append("projectName=$projectName,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBuildsForProjectRequest

        if (nextToken != other.nextToken) return false
        if (projectName != other.projectName) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a *nextToken*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the CodeBuild project.
         */
        public var projectName: kotlin.String? = null
        /**
         * The order to sort the results in. The results are sorted by build number, not the build identifier. If this is not specified, the results are sorted in descending order.
         *
         * Valid values include:
         * + `ASCENDING`: List the build identifiers in ascending order, by build number.
         * + `DESCENDING`: List the build identifiers in descending order, by build number.
         *
         * If the project has more than 100 builds, setting the sort order will result in an error.
         */
        public var sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest) : this() {
            this.nextToken = x.nextToken
            this.projectName = x.projectName
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest = ListBuildsForProjectRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
