// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A set of dedicated instances for your build environment.
 */
public class Fleet private constructor(builder: Builder) {
    /**
     * The ARN of the compute fleet.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     */
    public val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * Information about the compute resources the compute fleet uses. Available values include:
     * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
     * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
     * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
     *
     *  If you use `BUILD_GENERAL1_SMALL`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
     *
     *  If you use `BUILD_GENERAL1_LARGE`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
     */
    public val computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = builder.computeType
    /**
     * The time at which the compute fleet was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The environment type of the compute fleet.
     * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
     * + The environment type `MAC_ARM` is available for Medium fleets only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
     * + The environment type `MAC_ARM` is available for Large fleets only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
     * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
     * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
     */
    public val environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = builder.environmentType
    /**
     * The service role associated with the compute fleet. For more information, see [ Allow a user to add a permission policy for a fleet service role](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html) in the *CodeBuild User Guide*.
     */
    public val fleetServiceRole: kotlin.String? = builder.fleetServiceRole
    /**
     * The ID of the compute fleet.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Machine Image (AMI) of the compute fleet.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The time at which the compute fleet was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The name of the compute fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The compute fleet overflow behavior.
     * + For overflow behavior `QUEUE`, your overflow builds need to wait on the existing fleet instance to become available.
     * + For overflow behavior `ON_DEMAND`, your overflow builds run on CodeBuild on-demand.If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see [Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC network interface](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface).
     */
    public val overflowBehavior: aws.sdk.kotlin.services.codebuild.model.FleetOverflowBehavior? = builder.overflowBehavior
    /**
     * The scaling configuration of the compute fleet.
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput? = builder.scalingConfiguration
    /**
     * The status of the compute fleet.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.FleetStatus? = builder.status
    /**
     * A list of tag key and value pairs associated with this compute fleet.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Information about the VPC configuration that CodeBuild accesses.
     */
    public val vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Fleet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Fleet(")
        append("arn=$arn,")
        append("baseCapacity=$baseCapacity,")
        append("computeType=$computeType,")
        append("created=$created,")
        append("environmentType=$environmentType,")
        append("fleetServiceRole=$fleetServiceRole,")
        append("id=$id,")
        append("imageId=$imageId,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("overflowBehavior=$overflowBehavior,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("status=$status,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (baseCapacity ?: 0)
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (environmentType?.hashCode() ?: 0)
        result = 31 * result + (fleetServiceRole?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overflowBehavior?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Fleet

        if (arn != other.arn) return false
        if (baseCapacity != other.baseCapacity) return false
        if (computeType != other.computeType) return false
        if (created != other.created) return false
        if (environmentType != other.environmentType) return false
        if (fleetServiceRole != other.fleetServiceRole) return false
        if (id != other.id) return false
        if (imageId != other.imageId) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (overflowBehavior != other.overflowBehavior) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Fleet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the compute fleet.
         */
        public var arn: kotlin.String? = null
        /**
         * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
         */
        public var baseCapacity: kotlin.Int? = null
        /**
         * Information about the compute resources the compute fleet uses. Available values include:
         * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
         * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
         * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
         *
         *  If you use `BUILD_GENERAL1_SMALL`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
         *
         *  If you use `BUILD_GENERAL1_LARGE`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
         */
        public var computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = null
        /**
         * The time at which the compute fleet was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment type of the compute fleet.
         * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
         * + The environment type `MAC_ARM` is available for Medium fleets only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
         * + The environment type `MAC_ARM` is available for Large fleets only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
         * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
         * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
         */
        public var environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = null
        /**
         * The service role associated with the compute fleet. For more information, see [ Allow a user to add a permission policy for a fleet service role](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html) in the *CodeBuild User Guide*.
         */
        public var fleetServiceRole: kotlin.String? = null
        /**
         * The ID of the compute fleet.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Machine Image (AMI) of the compute fleet.
         */
        public var imageId: kotlin.String? = null
        /**
         * The time at which the compute fleet was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the compute fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The compute fleet overflow behavior.
         * + For overflow behavior `QUEUE`, your overflow builds need to wait on the existing fleet instance to become available.
         * + For overflow behavior `ON_DEMAND`, your overflow builds run on CodeBuild on-demand.If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see [Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC network interface](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface).
         */
        public var overflowBehavior: aws.sdk.kotlin.services.codebuild.model.FleetOverflowBehavior? = null
        /**
         * The scaling configuration of the compute fleet.
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput? = null
        /**
         * The status of the compute fleet.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.FleetStatus? = null
        /**
         * A list of tag key and value pairs associated with this compute fleet.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         */
        public var tags: List<Tag>? = null
        /**
         * Information about the VPC configuration that CodeBuild accesses.
         */
        public var vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Fleet) : this() {
            this.arn = x.arn
            this.baseCapacity = x.baseCapacity
            this.computeType = x.computeType
            this.created = x.created
            this.environmentType = x.environmentType
            this.fleetServiceRole = x.fleetServiceRole
            this.id = x.id
            this.imageId = x.imageId
            this.lastModified = x.lastModified
            this.name = x.name
            this.overflowBehavior = x.overflowBehavior
            this.scalingConfiguration = x.scalingConfiguration
            this.status = x.status
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Fleet = Fleet(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.FleetStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.codebuild.model.FleetStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.codebuild.model.FleetStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.codebuild.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.codebuild.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
