// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an exported environment variable.
 *
 * Exported environment variables are used in conjunction with CodePipeline to export environment variables from the current build stage to subsequent stages in the pipeline. For more information, see [Working with variables](https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html) in the *CodePipeline User Guide*.
 *
 *  During a build, the value of a variable is available starting with the `install` phase. It can be updated between the start of the `install` phase and the end of the `post_build` phase. After the `post_build` phase ends, the value of exported variables cannot change.
 */
public class ExportedEnvironmentVariable private constructor(builder: Builder) {
    /**
     * The name of the exported environment variable.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The value assigned to the exported environment variable.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ExportedEnvironmentVariable = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportedEnvironmentVariable(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportedEnvironmentVariable

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ExportedEnvironmentVariable = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the exported environment variable.
         */
        public var name: kotlin.String? = null
        /**
         * The value assigned to the exported environment variable.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ExportedEnvironmentVariable) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ExportedEnvironmentVariable = ExportedEnvironmentVariable(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
