// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about CloudWatch Logs for a build project.
 */
public class CloudWatchLogsConfig private constructor(builder: Builder) {
    /**
     * The group name of the logs in CloudWatch Logs. For more information, see [Working with Log Groups and Log Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The current status of the logs in CloudWatch Logs for a build project. Valid values are:
     * + `ENABLED`: CloudWatch Logs are enabled for this build project.
     * + `DISABLED`: CloudWatch Logs are not enabled for this build project.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.LogsConfigStatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The prefix of the stream name of the CloudWatch Logs. For more information, see [Working with Log Groups and Log Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchLogsConfig(")
        append("groupName=$groupName,")
        append("status=$status,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName?.hashCode() ?: 0
        result = 31 * result + (status.hashCode())
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchLogsConfig

        if (groupName != other.groupName) return false
        if (status != other.status) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The group name of the logs in CloudWatch Logs. For more information, see [Working with Log Groups and Log Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
         */
        public var groupName: kotlin.String? = null
        /**
         * The current status of the logs in CloudWatch Logs for a build project. Valid values are:
         * + `ENABLED`: CloudWatch Logs are enabled for this build project.
         * + `DISABLED`: CloudWatch Logs are not enabled for this build project.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.LogsConfigStatusType? = null
        /**
         * The prefix of the stream name of the CloudWatch Logs. For more information, see [Working with Log Groups and Log Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig) : this() {
            this.groupName = x.groupName
            this.status = x.status
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig = CloudWatchLogsConfig(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = LogsConfigStatusType.SdkUnknown("no value provided")
            return this
        }
    }
}
