// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information that defines how the CodeBuild build project reports the build status to the source provider.
 */
public class BuildStatusConfig private constructor(builder: Builder) {
    /**
     * Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     *
     * ## Bitbucket
     * This parameter is used for the `name` parameter in the Bitbucket commit status. For more information, see [build](https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build) in the Bitbucket API documentation.
     *
     * ## GitHub/GitHub Enterprise Server
     * This parameter is used for the `context` parameter in the GitHub commit status. For more information, see [Create a commit status](https://developer.github.com/v3/repos/statuses/#create-a-commit-status) in the GitHub developer guide.
     */
    public val context: kotlin.String? = builder.context
    /**
     * Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     *
     * ## Bitbucket
     * This parameter is used for the `url` parameter in the Bitbucket commit status. For more information, see [build](https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build) in the Bitbucket API documentation.
     *
     * ## GitHub/GitHub Enterprise Server
     * This parameter is used for the `target_url` parameter in the GitHub commit status. For more information, see [Create a commit status](https://developer.github.com/v3/repos/statuses/#create-a-commit-status) in the GitHub developer guide.
     */
    public val targetUrl: kotlin.String? = builder.targetUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildStatusConfig(")
        append("context=$context,")
        append("targetUrl=$targetUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = context?.hashCode() ?: 0
        result = 31 * result + (targetUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildStatusConfig

        if (context != other.context) return false
        if (targetUrl != other.targetUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
         *
         * ## Bitbucket
         * This parameter is used for the `name` parameter in the Bitbucket commit status. For more information, see [build](https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build) in the Bitbucket API documentation.
         *
         * ## GitHub/GitHub Enterprise Server
         * This parameter is used for the `context` parameter in the GitHub commit status. For more information, see [Create a commit status](https://developer.github.com/v3/repos/statuses/#create-a-commit-status) in the GitHub developer guide.
         */
        public var context: kotlin.String? = null
        /**
         * Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
         *
         * ## Bitbucket
         * This parameter is used for the `url` parameter in the Bitbucket commit status. For more information, see [build](https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build) in the Bitbucket API documentation.
         *
         * ## GitHub/GitHub Enterprise Server
         * This parameter is used for the `target_url` parameter in the GitHub commit status. For more information, see [Create a commit status](https://developer.github.com/v3/repos/statuses/#create-a-commit-status) in the GitHub developer guide.
         */
        public var targetUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig) : this() {
            this.context = x.context
            this.targetUrl = x.targetUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig = BuildStatusConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
