// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a stage for a batch build.
 */
public class BuildBatchPhase private constructor(builder: Builder) {
    /**
     * Additional information about the batch build phase. Especially to help troubleshoot a failed batch build.
     */
    public val contexts: List<PhaseContext>? = builder.contexts
    /**
     * How long, in seconds, between the starting and ending times of the batch build's phase.
     */
    public val durationInSeconds: kotlin.Long? = builder.durationInSeconds
    /**
     * When the batch build phase ended, expressed in Unix time format.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The current status of the batch build phase. Valid values include:
     *
     * ## FAILED
     * The build phase failed.
     *
     * ## FAULT
     * The build phase faulted.
     *
     * ## IN_PROGRESS
     * The build phase is still in progress.
     *
     * ## STOPPED
     * The build phase stopped.
     *
     * ## SUCCEEDED
     * The build phase succeeded.
     *
     * ## TIMED_OUT
     * The build phase timed out.
     */
    public val phaseStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = builder.phaseStatus
    /**
     * The name of the batch build phase. Valid values include:
     *
     * ## COMBINE_ARTIFACTS
     * Build output artifacts are being combined and uploaded to the output location.
     *
     * ## DOWNLOAD_BATCHSPEC
     * The batch build specification is being downloaded.
     *
     * ## FAILED
     * One or more of the builds failed.
     *
     * ## IN_PROGRESS
     * The batch build is in progress.
     *
     * ## STOPPED
     * The batch build was stopped.
     *
     * ## SUBMITTED
     * The btach build has been submitted.
     *
     * ## SUCCEEDED
     * The batch build succeeded.
     */
    public val phaseType: aws.sdk.kotlin.services.codebuild.model.BuildBatchPhaseType? = builder.phaseType
    /**
     * When the batch build phase started, expressed in Unix time format.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildBatchPhase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildBatchPhase(")
        append("contexts=$contexts,")
        append("durationInSeconds=$durationInSeconds,")
        append("endTime=$endTime,")
        append("phaseStatus=$phaseStatus,")
        append("phaseType=$phaseType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contexts?.hashCode() ?: 0
        result = 31 * result + (durationInSeconds?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (phaseStatus?.hashCode() ?: 0)
        result = 31 * result + (phaseType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildBatchPhase

        if (contexts != other.contexts) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (endTime != other.endTime) return false
        if (phaseStatus != other.phaseStatus) return false
        if (phaseType != other.phaseType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildBatchPhase = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional information about the batch build phase. Especially to help troubleshoot a failed batch build.
         */
        public var contexts: List<PhaseContext>? = null
        /**
         * How long, in seconds, between the starting and ending times of the batch build's phase.
         */
        public var durationInSeconds: kotlin.Long? = null
        /**
         * When the batch build phase ended, expressed in Unix time format.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the batch build phase. Valid values include:
         *
         * ## FAILED
         * The build phase failed.
         *
         * ## FAULT
         * The build phase faulted.
         *
         * ## IN_PROGRESS
         * The build phase is still in progress.
         *
         * ## STOPPED
         * The build phase stopped.
         *
         * ## SUCCEEDED
         * The build phase succeeded.
         *
         * ## TIMED_OUT
         * The build phase timed out.
         */
        public var phaseStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = null
        /**
         * The name of the batch build phase. Valid values include:
         *
         * ## COMBINE_ARTIFACTS
         * Build output artifacts are being combined and uploaded to the output location.
         *
         * ## DOWNLOAD_BATCHSPEC
         * The batch build specification is being downloaded.
         *
         * ## FAILED
         * One or more of the builds failed.
         *
         * ## IN_PROGRESS
         * The batch build is in progress.
         *
         * ## STOPPED
         * The batch build was stopped.
         *
         * ## SUBMITTED
         * The btach build has been submitted.
         *
         * ## SUCCEEDED
         * The batch build succeeded.
         */
        public var phaseType: aws.sdk.kotlin.services.codebuild.model.BuildBatchPhaseType? = null
        /**
         * When the batch build phase started, expressed in Unix time format.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildBatchPhase) : this() {
            this.contexts = x.contexts
            this.durationInSeconds = x.durationInSeconds
            this.endTime = x.endTime
            this.phaseStatus = x.phaseStatus
            this.phaseType = x.phaseType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildBatchPhase = BuildBatchPhase(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
