// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a build.
 */
public class Build private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the build.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Information about the output artifacts for the build.
     */
    public val artifacts: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts? = builder.artifacts
    /**
     * The ARN of the batch build that this build is a member of, if applicable.
     */
    public val buildBatchArn: kotlin.String? = builder.buildBatchArn
    /**
     * Whether the build is complete. True if complete; otherwise, false.
     */
    public val buildComplete: kotlin.Boolean = builder.buildComplete
    /**
     * The number of the build. For each project, the `buildNumber` of its first build is `1`. The `buildNumber` of each subsequent build is incremented by `1`. If a build is deleted, the `buildNumber` of other builds does not change.
     */
    public val buildNumber: kotlin.Long? = builder.buildNumber
    /**
     * The current status of the build. Valid values include:
     * + `FAILED`: The build failed.
     * + `FAULT`: The build faulted.
     * + `IN_PROGRESS`: The build is still in progress.
     * + `STOPPED`: The build stopped.
     * + `SUCCEEDED`: The build succeeded.
     * + `TIMED_OUT`: The build timed out.
     */
    public val buildStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = builder.buildStatus
    /**
     * Information about the cache for the build.
     */
    public val cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = builder.cache
    /**
     * The current build phase.
     */
    public val currentPhase: kotlin.String? = builder.currentPhase
    /**
     * Contains information about the debug session for this build.
     */
    public val debugSession: aws.sdk.kotlin.services.codebuild.model.DebugSession? = builder.debugSession
    /**
     * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     *
     *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     *
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * When the build process ended, expressed in Unix time format.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Information about the build environment for this build.
     */
    public val environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = builder.environment
    /**
     * A list of exported environment variables for this build.
     *
     * Exported environment variables are used in conjunction with CodePipeline to export environment variables from the current build stage to subsequent stages in the pipeline. For more information, see [Working with variables](https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html) in the *CodePipeline User Guide*.
     */
    public val exportedEnvironmentVariables: List<ExportedEnvironmentVariable>? = builder.exportedEnvironmentVariables
    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
     */
    public val fileSystemLocations: List<ProjectFileSystemLocation>? = builder.fileSystemLocations
    /**
     * The unique ID for the build.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The entity that started the build. Valid values include:
     * + If CodePipeline started the build, the pipeline's name (for example, `codepipeline/my-demo-pipeline`).
     * + If a user started the build, the user's name (for example, `MyUserName`).
     * + If the Jenkins plugin for CodeBuild started the build, the string `CodeBuild-Jenkins-Plugin`.
     */
    public val initiator: kotlin.String? = builder.initiator
    /**
     * Information about the build's logs in CloudWatch Logs.
     */
    public val logs: aws.sdk.kotlin.services.codebuild.model.LogsLocation? = builder.logs
    /**
     * Describes a network interface.
     */
    public val networkInterface: aws.sdk.kotlin.services.codebuild.model.NetworkInterface? = builder.networkInterface
    /**
     * Information about all previous build phases that are complete and information about any current build phase that is not yet complete.
     */
    public val phases: List<BuildPhase>? = builder.phases
    /**
     * The name of the CodeBuild project.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    public val queuedTimeoutInMinutes: kotlin.Int? = builder.queuedTimeoutInMinutes
    /**
     * An array of the ARNs associated with this build's reports.
     */
    public val reportArns: List<String>? = builder.reportArns
    /**
     * An identifier for the version of this build's source code.
     * +  For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.
     * +  For CodePipeline, the source revision provided by CodePipeline.
     * +  For Amazon S3, this does not apply.
     */
    public val resolvedSourceVersion: kotlin.String? = builder.resolvedSourceVersion
    /**
     * An array of `ProjectArtifacts` objects.
     */
    public val secondaryArtifacts: List<BuildArtifacts>? = builder.secondaryArtifacts
    /**
     * An array of `ProjectSourceVersion` objects. Each `ProjectSourceVersion` must be one of:
     * + For CodeCommit: the commit ID, branch, or Git tag to use.
     * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     */
    public val secondarySourceVersions: List<ProjectSourceVersion>? = builder.secondarySourceVersions
    /**
     * An array of `ProjectSource` objects.
     */
    public val secondarySources: List<ProjectSource>? = builder.secondarySources
    /**
     * The name of a service role used for this build.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Information about the source code to be built.
     */
    public val source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = builder.source
    /**
     * Any version identifier for the version of the source code to be built. If `sourceVersion` is specified at the project level, then this `sourceVersion` (at the build level) takes precedence.
     *
     *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion
    /**
     * When the build process started, expressed in Unix time format.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this build if it does not get marked as completed.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes
    /**
     * If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter that identifies the VPC ID and the list of security group IDs and subnet IDs. The security groups and subnets must belong to the same VPC. You must provide at least one security group and one subnet ID.
     */
    public val vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Build = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Build(")
        append("arn=$arn,")
        append("artifacts=$artifacts,")
        append("buildBatchArn=$buildBatchArn,")
        append("buildComplete=$buildComplete,")
        append("buildNumber=$buildNumber,")
        append("buildStatus=$buildStatus,")
        append("cache=$cache,")
        append("currentPhase=$currentPhase,")
        append("debugSession=$debugSession,")
        append("encryptionKey=$encryptionKey,")
        append("endTime=$endTime,")
        append("environment=$environment,")
        append("exportedEnvironmentVariables=$exportedEnvironmentVariables,")
        append("fileSystemLocations=$fileSystemLocations,")
        append("id=$id,")
        append("initiator=$initiator,")
        append("logs=$logs,")
        append("networkInterface=$networkInterface,")
        append("phases=$phases,")
        append("projectName=$projectName,")
        append("queuedTimeoutInMinutes=$queuedTimeoutInMinutes,")
        append("reportArns=$reportArns,")
        append("resolvedSourceVersion=$resolvedSourceVersion,")
        append("secondaryArtifacts=$secondaryArtifacts,")
        append("secondarySourceVersions=$secondarySourceVersions,")
        append("secondarySources=$secondarySources,")
        append("serviceRole=$serviceRole,")
        append("source=$source,")
        append("sourceVersion=$sourceVersion,")
        append("startTime=$startTime,")
        append("timeoutInMinutes=$timeoutInMinutes,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (artifacts?.hashCode() ?: 0)
        result = 31 * result + (buildBatchArn?.hashCode() ?: 0)
        result = 31 * result + (buildComplete.hashCode())
        result = 31 * result + (buildNumber?.hashCode() ?: 0)
        result = 31 * result + (buildStatus?.hashCode() ?: 0)
        result = 31 * result + (cache?.hashCode() ?: 0)
        result = 31 * result + (currentPhase?.hashCode() ?: 0)
        result = 31 * result + (debugSession?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (exportedEnvironmentVariables?.hashCode() ?: 0)
        result = 31 * result + (fileSystemLocations?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (initiator?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (networkInterface?.hashCode() ?: 0)
        result = 31 * result + (phases?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (queuedTimeoutInMinutes ?: 0)
        result = 31 * result + (reportArns?.hashCode() ?: 0)
        result = 31 * result + (resolvedSourceVersion?.hashCode() ?: 0)
        result = 31 * result + (secondaryArtifacts?.hashCode() ?: 0)
        result = 31 * result + (secondarySourceVersions?.hashCode() ?: 0)
        result = 31 * result + (secondarySources?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Build

        if (arn != other.arn) return false
        if (artifacts != other.artifacts) return false
        if (buildBatchArn != other.buildBatchArn) return false
        if (buildComplete != other.buildComplete) return false
        if (buildNumber != other.buildNumber) return false
        if (buildStatus != other.buildStatus) return false
        if (cache != other.cache) return false
        if (currentPhase != other.currentPhase) return false
        if (debugSession != other.debugSession) return false
        if (encryptionKey != other.encryptionKey) return false
        if (endTime != other.endTime) return false
        if (environment != other.environment) return false
        if (exportedEnvironmentVariables != other.exportedEnvironmentVariables) return false
        if (fileSystemLocations != other.fileSystemLocations) return false
        if (id != other.id) return false
        if (initiator != other.initiator) return false
        if (logs != other.logs) return false
        if (networkInterface != other.networkInterface) return false
        if (phases != other.phases) return false
        if (projectName != other.projectName) return false
        if (queuedTimeoutInMinutes != other.queuedTimeoutInMinutes) return false
        if (reportArns != other.reportArns) return false
        if (resolvedSourceVersion != other.resolvedSourceVersion) return false
        if (secondaryArtifacts != other.secondaryArtifacts) return false
        if (secondarySourceVersions != other.secondarySourceVersions) return false
        if (secondarySources != other.secondarySources) return false
        if (serviceRole != other.serviceRole) return false
        if (source != other.source) return false
        if (sourceVersion != other.sourceVersion) return false
        if (startTime != other.startTime) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Build = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the build.
         */
        public var arn: kotlin.String? = null
        /**
         * Information about the output artifacts for the build.
         */
        public var artifacts: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts? = null
        /**
         * The ARN of the batch build that this build is a member of, if applicable.
         */
        public var buildBatchArn: kotlin.String? = null
        /**
         * Whether the build is complete. True if complete; otherwise, false.
         */
        public var buildComplete: kotlin.Boolean = false
        /**
         * The number of the build. For each project, the `buildNumber` of its first build is `1`. The `buildNumber` of each subsequent build is incremented by `1`. If a build is deleted, the `buildNumber` of other builds does not change.
         */
        public var buildNumber: kotlin.Long? = null
        /**
         * The current status of the build. Valid values include:
         * + `FAILED`: The build failed.
         * + `FAULT`: The build faulted.
         * + `IN_PROGRESS`: The build is still in progress.
         * + `STOPPED`: The build stopped.
         * + `SUCCEEDED`: The build succeeded.
         * + `TIMED_OUT`: The build timed out.
         */
        public var buildStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = null
        /**
         * Information about the cache for the build.
         */
        public var cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = null
        /**
         * The current build phase.
         */
        public var currentPhase: kotlin.String? = null
        /**
         * Contains information about the debug session for this build.
         */
        public var debugSession: aws.sdk.kotlin.services.codebuild.model.DebugSession? = null
        /**
         * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
         *
         *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         *
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * When the build process ended, expressed in Unix time format.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the build environment for this build.
         */
        public var environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = null
        /**
         * A list of exported environment variables for this build.
         *
         * Exported environment variables are used in conjunction with CodePipeline to export environment variables from the current build stage to subsequent stages in the pipeline. For more information, see [Working with variables](https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html) in the *CodePipeline User Guide*.
         */
        public var exportedEnvironmentVariables: List<ExportedEnvironmentVariable>? = null
        /**
         * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
         */
        public var fileSystemLocations: List<ProjectFileSystemLocation>? = null
        /**
         * The unique ID for the build.
         */
        public var id: kotlin.String? = null
        /**
         * The entity that started the build. Valid values include:
         * + If CodePipeline started the build, the pipeline's name (for example, `codepipeline/my-demo-pipeline`).
         * + If a user started the build, the user's name (for example, `MyUserName`).
         * + If the Jenkins plugin for CodeBuild started the build, the string `CodeBuild-Jenkins-Plugin`.
         */
        public var initiator: kotlin.String? = null
        /**
         * Information about the build's logs in CloudWatch Logs.
         */
        public var logs: aws.sdk.kotlin.services.codebuild.model.LogsLocation? = null
        /**
         * Describes a network interface.
         */
        public var networkInterface: aws.sdk.kotlin.services.codebuild.model.NetworkInterface? = null
        /**
         * Information about all previous build phases that are complete and information about any current build phase that is not yet complete.
         */
        public var phases: List<BuildPhase>? = null
        /**
         * The name of the CodeBuild project.
         */
        public var projectName: kotlin.String? = null
        /**
         * The number of minutes a build is allowed to be queued before it times out.
         */
        public var queuedTimeoutInMinutes: kotlin.Int? = null
        /**
         * An array of the ARNs associated with this build's reports.
         */
        public var reportArns: List<String>? = null
        /**
         * An identifier for the version of this build's source code.
         * +  For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.
         * +  For CodePipeline, the source revision provided by CodePipeline.
         * +  For Amazon S3, this does not apply.
         */
        public var resolvedSourceVersion: kotlin.String? = null
        /**
         * An array of `ProjectArtifacts` objects.
         */
        public var secondaryArtifacts: List<BuildArtifacts>? = null
        /**
         * An array of `ProjectSourceVersion` objects. Each `ProjectSourceVersion` must be one of:
         * + For CodeCommit: the commit ID, branch, or Git tag to use.
         * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         */
        public var secondarySourceVersions: List<ProjectSourceVersion>? = null
        /**
         * An array of `ProjectSource` objects.
         */
        public var secondarySources: List<ProjectSource>? = null
        /**
         * The name of a service role used for this build.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Information about the source code to be built.
         */
        public var source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = null
        /**
         * Any version identifier for the version of the source code to be built. If `sourceVersion` is specified at the project level, then this `sourceVersion` (at the build level) takes precedence.
         *
         *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
         */
        public var sourceVersion: kotlin.String? = null
        /**
         * When the build process started, expressed in Unix time format.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this build if it does not get marked as completed.
         */
        public var timeoutInMinutes: kotlin.Int? = null
        /**
         * If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter that identifies the VPC ID and the list of security group IDs and subnet IDs. The security groups and subnets must belong to the same VPC. You must provide at least one security group and one subnet ID.
         */
        public var vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Build) : this() {
            this.arn = x.arn
            this.artifacts = x.artifacts
            this.buildBatchArn = x.buildBatchArn
            this.buildComplete = x.buildComplete
            this.buildNumber = x.buildNumber
            this.buildStatus = x.buildStatus
            this.cache = x.cache
            this.currentPhase = x.currentPhase
            this.debugSession = x.debugSession
            this.encryptionKey = x.encryptionKey
            this.endTime = x.endTime
            this.environment = x.environment
            this.exportedEnvironmentVariables = x.exportedEnvironmentVariables
            this.fileSystemLocations = x.fileSystemLocations
            this.id = x.id
            this.initiator = x.initiator
            this.logs = x.logs
            this.networkInterface = x.networkInterface
            this.phases = x.phases
            this.projectName = x.projectName
            this.queuedTimeoutInMinutes = x.queuedTimeoutInMinutes
            this.reportArns = x.reportArns
            this.resolvedSourceVersion = x.resolvedSourceVersion
            this.secondaryArtifacts = x.secondaryArtifacts
            this.secondarySourceVersions = x.secondarySourceVersions
            this.secondarySources = x.secondarySources
            this.serviceRole = x.serviceRole
            this.source = x.source
            this.sourceVersion = x.sourceVersion
            this.startTime = x.startTime
            this.timeoutInMinutes = x.timeoutInMinutes
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Build = Build(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BuildArtifacts] inside the given [block]
         */
        public fun artifacts(block: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts.Builder.() -> kotlin.Unit) {
            this.artifacts = aws.sdk.kotlin.services.codebuild.model.BuildArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectCache] inside the given [block]
         */
        public fun cache(block: aws.sdk.kotlin.services.codebuild.model.ProjectCache.Builder.() -> kotlin.Unit) {
            this.cache = aws.sdk.kotlin.services.codebuild.model.ProjectCache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.DebugSession] inside the given [block]
         */
        public fun debugSession(block: aws.sdk.kotlin.services.codebuild.model.DebugSession.Builder.() -> kotlin.Unit) {
            this.debugSession = aws.sdk.kotlin.services.codebuild.model.DebugSession.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.LogsLocation] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.codebuild.model.LogsLocation.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.codebuild.model.LogsLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.NetworkInterface] inside the given [block]
         */
        public fun networkInterface(block: aws.sdk.kotlin.services.codebuild.model.NetworkInterface.Builder.() -> kotlin.Unit) {
            this.networkInterface = aws.sdk.kotlin.services.codebuild.model.NetworkInterface.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.codebuild.model.ProjectSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codebuild.model.ProjectSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.codebuild.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.codebuild.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
