// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.codebuild.auth.CodeBuildAuthSchemeProvider
import aws.sdk.kotlin.services.codebuild.auth.DefaultCodeBuildAuthSchemeProvider
import aws.sdk.kotlin.services.codebuild.endpoints.CodeBuildEndpointParameters
import aws.sdk.kotlin.services.codebuild.endpoints.CodeBuildEndpointProvider
import aws.sdk.kotlin.services.codebuild.endpoints.DefaultCodeBuildEndpointProvider
import aws.sdk.kotlin.services.codebuild.model.BatchDeleteBuildsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchDeleteBuildsResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetBuildBatchesRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetBuildBatchesResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetBuildsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetBuildsResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetFleetsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetFleetsResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetProjectsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetProjectsResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetReportGroupsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetReportGroupsResponse
import aws.sdk.kotlin.services.codebuild.model.BatchGetReportsRequest
import aws.sdk.kotlin.services.codebuild.model.BatchGetReportsResponse
import aws.sdk.kotlin.services.codebuild.model.CreateFleetRequest
import aws.sdk.kotlin.services.codebuild.model.CreateFleetResponse
import aws.sdk.kotlin.services.codebuild.model.CreateProjectRequest
import aws.sdk.kotlin.services.codebuild.model.CreateProjectResponse
import aws.sdk.kotlin.services.codebuild.model.CreateReportGroupRequest
import aws.sdk.kotlin.services.codebuild.model.CreateReportGroupResponse
import aws.sdk.kotlin.services.codebuild.model.CreateWebhookRequest
import aws.sdk.kotlin.services.codebuild.model.CreateWebhookResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteBuildBatchRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteBuildBatchResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteFleetRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteFleetResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteProjectRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteProjectResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteReportGroupRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteReportGroupResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteReportRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteReportResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteSourceCredentialsRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteSourceCredentialsResponse
import aws.sdk.kotlin.services.codebuild.model.DeleteWebhookRequest
import aws.sdk.kotlin.services.codebuild.model.DeleteWebhookResponse
import aws.sdk.kotlin.services.codebuild.model.DescribeCodeCoveragesRequest
import aws.sdk.kotlin.services.codebuild.model.DescribeCodeCoveragesResponse
import aws.sdk.kotlin.services.codebuild.model.DescribeTestCasesRequest
import aws.sdk.kotlin.services.codebuild.model.DescribeTestCasesResponse
import aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendRequest
import aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendResponse
import aws.sdk.kotlin.services.codebuild.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.codebuild.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.codebuild.model.ImportSourceCredentialsRequest
import aws.sdk.kotlin.services.codebuild.model.ImportSourceCredentialsResponse
import aws.sdk.kotlin.services.codebuild.model.InvalidateProjectCacheRequest
import aws.sdk.kotlin.services.codebuild.model.InvalidateProjectCacheResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesForProjectRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesForProjectResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildsRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildsResponse
import aws.sdk.kotlin.services.codebuild.model.ListCuratedEnvironmentImagesRequest
import aws.sdk.kotlin.services.codebuild.model.ListCuratedEnvironmentImagesResponse
import aws.sdk.kotlin.services.codebuild.model.ListFleetsRequest
import aws.sdk.kotlin.services.codebuild.model.ListFleetsResponse
import aws.sdk.kotlin.services.codebuild.model.ListProjectsRequest
import aws.sdk.kotlin.services.codebuild.model.ListProjectsResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportGroupsRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportGroupsResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportsForReportGroupRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportsForReportGroupResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportsRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportsResponse
import aws.sdk.kotlin.services.codebuild.model.ListSharedProjectsRequest
import aws.sdk.kotlin.services.codebuild.model.ListSharedProjectsResponse
import aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest
import aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsResponse
import aws.sdk.kotlin.services.codebuild.model.ListSourceCredentialsRequest
import aws.sdk.kotlin.services.codebuild.model.ListSourceCredentialsResponse
import aws.sdk.kotlin.services.codebuild.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.codebuild.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.codebuild.model.RetryBuildBatchRequest
import aws.sdk.kotlin.services.codebuild.model.RetryBuildBatchResponse
import aws.sdk.kotlin.services.codebuild.model.RetryBuildRequest
import aws.sdk.kotlin.services.codebuild.model.RetryBuildResponse
import aws.sdk.kotlin.services.codebuild.model.StartBuildBatchRequest
import aws.sdk.kotlin.services.codebuild.model.StartBuildBatchResponse
import aws.sdk.kotlin.services.codebuild.model.StartBuildRequest
import aws.sdk.kotlin.services.codebuild.model.StartBuildResponse
import aws.sdk.kotlin.services.codebuild.model.StopBuildBatchRequest
import aws.sdk.kotlin.services.codebuild.model.StopBuildBatchResponse
import aws.sdk.kotlin.services.codebuild.model.StopBuildRequest
import aws.sdk.kotlin.services.codebuild.model.StopBuildResponse
import aws.sdk.kotlin.services.codebuild.model.UpdateFleetRequest
import aws.sdk.kotlin.services.codebuild.model.UpdateFleetResponse
import aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest
import aws.sdk.kotlin.services.codebuild.model.UpdateProjectResponse
import aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityRequest
import aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityResponse
import aws.sdk.kotlin.services.codebuild.model.UpdateReportGroupRequest
import aws.sdk.kotlin.services.codebuild.model.UpdateReportGroupResponse
import aws.sdk.kotlin.services.codebuild.model.UpdateWebhookRequest
import aws.sdk.kotlin.services.codebuild.model.UpdateWebhookResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CodeBuild"
public const val SdkVersion: String = "1.3.27"
public const val ServiceApiVersion: String = "2016-10-06"

/**
 * # CodeBuild
 * CodeBuild is a fully managed build service in the cloud. CodeBuild compiles your source code, runs unit tests, and produces artifacts that are ready to deploy. CodeBuild eliminates the need to provision, manage, and scale your own build servers. It provides prepackaged build environments for the most popular programming languages and build tools, such as Apache Maven, Gradle, and more. You can also fully customize build environments in CodeBuild to use your own build tools. CodeBuild scales automatically to meet peak build requests. You pay only for the build time you consume. For more information about CodeBuild, see the *[CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/welcome.html).*
 */
public interface CodeBuildClient : SdkClient {
    /**
     * CodeBuildClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeBuildClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeBuild",
                "CODEBUILD",
                "codebuild",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeBuildClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeBuildClient = DefaultCodeBuildClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CodeBuildEndpointProvider = builder.endpointProvider ?: DefaultCodeBuildEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeBuildAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeBuildAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeBuild"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeBuildEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeBuildAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes one or more builds.
     */
    public suspend fun batchDeleteBuilds(input: BatchDeleteBuildsRequest): BatchDeleteBuildsResponse

    /**
     * Retrieves information about one or more batch builds.
     */
    public suspend fun batchGetBuildBatches(input: BatchGetBuildBatchesRequest): BatchGetBuildBatchesResponse

    /**
     * Gets information about one or more builds.
     */
    public suspend fun batchGetBuilds(input: BatchGetBuildsRequest): BatchGetBuildsResponse

    /**
     * Gets information about one or more compute fleets.
     */
    public suspend fun batchGetFleets(input: BatchGetFleetsRequest): BatchGetFleetsResponse

    /**
     * Gets information about one or more build projects.
     */
    public suspend fun batchGetProjects(input: BatchGetProjectsRequest): BatchGetProjectsResponse

    /**
     * Returns an array of report groups.
     */
    public suspend fun batchGetReportGroups(input: BatchGetReportGroupsRequest): BatchGetReportGroupsResponse

    /**
     * Returns an array of reports.
     */
    public suspend fun batchGetReports(input: BatchGetReportsRequest): BatchGetReportsResponse

    /**
     * Creates a compute fleet.
     */
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates a build project.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a report group. A report group contains a collection of reports.
     */
    public suspend fun createReportGroup(input: CreateReportGroupRequest): CreateReportGroupResponse

    /**
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
     *
     * If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then two identical builds are created for each commit. One build is triggered through webhooks, and one through CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the Webhook box. For more information, see step 5 in [Change a Build Project's Settings](https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console).
     */
    public suspend fun createWebhook(input: CreateWebhookRequest): CreateWebhookResponse

    /**
     * Deletes a batch build.
     */
    public suspend fun deleteBuildBatch(input: DeleteBuildBatchRequest): DeleteBuildBatchResponse

    /**
     * Deletes a compute fleet. When you delete a compute fleet, its builds are not deleted.
     */
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes a build project. When you delete a project, its builds are not deleted.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a report.
     */
    public suspend fun deleteReport(input: DeleteReportRequest): DeleteReportResponse

    /**
     * Deletes a report group. Before you delete a report group, you must delete its reports.
     */
    public suspend fun deleteReportGroup(input: DeleteReportGroupRequest): DeleteReportGroupResponse

    /**
     * Deletes a resource policy that is identified by its resource ARN.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
     */
    public suspend fun deleteSourceCredentials(input: DeleteSourceCredentialsRequest): DeleteSourceCredentialsResponse

    /**
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
     */
    public suspend fun deleteWebhook(input: DeleteWebhookRequest): DeleteWebhookResponse

    /**
     * Retrieves one or more code coverage reports.
     */
    public suspend fun describeCodeCoverages(input: DescribeCodeCoveragesRequest): DescribeCodeCoveragesResponse

    /**
     * Returns a list of details about test cases for a report.
     */
    public suspend fun describeTestCases(input: DescribeTestCasesRequest): DescribeTestCasesResponse

    /**
     * Analyzes and accumulates test report values for the specified test reports.
     */
    public suspend fun getReportGroupTrend(input: GetReportGroupTrendRequest): GetReportGroupTrendResponse

    /**
     * Gets a resource policy that is identified by its resource ARN.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket repository.
     */
    public suspend fun importSourceCredentials(input: ImportSourceCredentialsRequest): ImportSourceCredentialsResponse

    /**
     * Resets the cache for a project.
     */
    public suspend fun invalidateProjectCache(input: InvalidateProjectCacheRequest): InvalidateProjectCacheResponse

    /**
     * Retrieves the identifiers of your build batches in the current region.
     */
    public suspend fun listBuildBatches(input: ListBuildBatchesRequest = ListBuildBatchesRequest { }): ListBuildBatchesResponse

    /**
     * Retrieves the identifiers of the build batches for a specific project.
     */
    public suspend fun listBuildBatchesForProject(input: ListBuildBatchesForProjectRequest = ListBuildBatchesForProjectRequest { }): ListBuildBatchesForProjectResponse

    /**
     * Gets a list of build IDs, with each build ID representing a single build.
     */
    public suspend fun listBuilds(input: ListBuildsRequest = ListBuildsRequest { }): ListBuildsResponse

    /**
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a single build.
     */
    public suspend fun listBuildsForProject(input: ListBuildsForProjectRequest): ListBuildsForProjectResponse

    /**
     * Gets information about Docker images that are managed by CodeBuild.
     */
    public suspend fun listCuratedEnvironmentImages(input: ListCuratedEnvironmentImagesRequest = ListCuratedEnvironmentImagesRequest { }): ListCuratedEnvironmentImagesResponse

    /**
     * Gets a list of compute fleet names with each compute fleet name representing a single compute fleet.
     */
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest { }): ListFleetsResponse

    /**
     * Gets a list of build project names, with each build project name representing a single build project.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest { }): ListProjectsResponse

    /**
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     */
    public suspend fun listReportGroups(input: ListReportGroupsRequest = ListReportGroupsRequest { }): ListReportGroupsResponse

    /**
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     */
    public suspend fun listReports(input: ListReportsRequest = ListReportsRequest { }): ListReportsResponse

    /**
     * Returns a list of ARNs for the reports that belong to a `ReportGroup`.
     */
    public suspend fun listReportsForReportGroup(input: ListReportsForReportGroupRequest): ListReportsForReportGroupResponse

    /**
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     */
    public suspend fun listSharedProjects(input: ListSharedProjectsRequest = ListSharedProjectsRequest { }): ListSharedProjectsResponse

    /**
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     */
    public suspend fun listSharedReportGroups(input: ListSharedReportGroupsRequest = ListSharedReportGroupsRequest { }): ListSharedReportGroupsResponse

    /**
     * Returns a list of `SourceCredentialsInfo` objects.
     */
    public suspend fun listSourceCredentials(input: ListSourceCredentialsRequest = ListSourceCredentialsRequest { }): ListSourceCredentialsResponse

    /**
     * Stores a resource policy for the ARN of a `Project` or `ReportGroup` object.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Restarts a build.
     */
    public suspend fun retryBuild(input: RetryBuildRequest = RetryBuildRequest { }): RetryBuildResponse

    /**
     * Restarts a failed batch build. Only batch builds that have failed can be retried.
     */
    public suspend fun retryBuildBatch(input: RetryBuildBatchRequest = RetryBuildBatchRequest { }): RetryBuildBatchResponse

    /**
     * Starts running a build with the settings defined in the project. These setting include: how to run a build, where to get the source code, which build environment to use, which build commands to run, and where to store the build output.
     *
     * You can also start a build run by overriding some of the build settings in the project. The overrides only apply for that specific start build request. The settings in the project are unaltered.
     */
    public suspend fun startBuild(input: StartBuildRequest): StartBuildResponse

    /**
     * Starts a batch build for a project.
     */
    public suspend fun startBuildBatch(input: StartBuildBatchRequest): StartBuildBatchResponse

    /**
     * Attempts to stop running a build.
     */
    public suspend fun stopBuild(input: StopBuildRequest): StopBuildResponse

    /**
     * Stops a running batch build.
     */
    public suspend fun stopBuildBatch(input: StopBuildBatchRequest): StopBuildBatchResponse

    /**
     * Updates a compute fleet.
     */
    public suspend fun updateFleet(input: UpdateFleetRequest): UpdateFleetResponse

    /**
     * Changes the settings of a build project.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Changes the public visibility for a project. The project's build results, logs, and artifacts are available to the general public. For more information, see [Public build projects](https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html) in the *CodeBuild User Guide*.
     *
     * The following should be kept in mind when making your projects public:
     * + All of a project's build results, logs, and artifacts, including builds that were run when the project was private, are available to the general public.
     * + All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive information may have been output to the build logs and artifacts. You must be careful about what information is output to the build logs. Some best practice are:
     *    + Do not store sensitive values in environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store or Secrets Manager to store sensitive values.
     *    + Follow [Best practices for using webhooks](https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices) in the *CodeBuild User Guide* to limit which entities can trigger a build, and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.
     * + A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull requests to verify that the pull request is a legitimate change. We also recommend that you validate any artifacts with their checksums to make sure that the correct artifacts are being downloaded.
     */
    public suspend fun updateProjectVisibility(input: UpdateProjectVisibilityRequest): UpdateProjectVisibilityResponse

    /**
     * Updates a report group.
     */
    public suspend fun updateReportGroup(input: UpdateReportGroupRequest): UpdateReportGroupResponse

    /**
     * Updates the webhook associated with an CodeBuild build project.
     *
     *  If you use Bitbucket for your repository, `rotateSecret` is ignored.
     */
    public suspend fun updateWebhook(input: UpdateWebhookRequest): UpdateWebhookResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeBuildClient.withConfig(block: CodeBuildClient.Config.Builder.() -> Unit): CodeBuildClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeBuildClient(newConfig)
}

/**
 * Deletes one or more builds.
 */
public suspend inline fun CodeBuildClient.batchDeleteBuilds(crossinline block: BatchDeleteBuildsRequest.Builder.() -> Unit): BatchDeleteBuildsResponse = batchDeleteBuilds(BatchDeleteBuildsRequest.Builder().apply(block).build())

/**
 * Retrieves information about one or more batch builds.
 */
public suspend inline fun CodeBuildClient.batchGetBuildBatches(crossinline block: BatchGetBuildBatchesRequest.Builder.() -> Unit): BatchGetBuildBatchesResponse = batchGetBuildBatches(BatchGetBuildBatchesRequest.Builder().apply(block).build())

/**
 * Gets information about one or more builds.
 */
public suspend inline fun CodeBuildClient.batchGetBuilds(crossinline block: BatchGetBuildsRequest.Builder.() -> Unit): BatchGetBuildsResponse = batchGetBuilds(BatchGetBuildsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more compute fleets.
 */
public suspend inline fun CodeBuildClient.batchGetFleets(crossinline block: BatchGetFleetsRequest.Builder.() -> Unit): BatchGetFleetsResponse = batchGetFleets(BatchGetFleetsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more build projects.
 */
public suspend inline fun CodeBuildClient.batchGetProjects(crossinline block: BatchGetProjectsRequest.Builder.() -> Unit): BatchGetProjectsResponse = batchGetProjects(BatchGetProjectsRequest.Builder().apply(block).build())

/**
 * Returns an array of report groups.
 */
public suspend inline fun CodeBuildClient.batchGetReportGroups(crossinline block: BatchGetReportGroupsRequest.Builder.() -> Unit): BatchGetReportGroupsResponse = batchGetReportGroups(BatchGetReportGroupsRequest.Builder().apply(block).build())

/**
 * Returns an array of reports.
 */
public suspend inline fun CodeBuildClient.batchGetReports(crossinline block: BatchGetReportsRequest.Builder.() -> Unit): BatchGetReportsResponse = batchGetReports(BatchGetReportsRequest.Builder().apply(block).build())

/**
 * Creates a compute fleet.
 */
public suspend inline fun CodeBuildClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Creates a build project.
 */
public suspend inline fun CodeBuildClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates a report group. A report group contains a collection of reports.
 */
public suspend inline fun CodeBuildClient.createReportGroup(crossinline block: CreateReportGroupRequest.Builder.() -> Unit): CreateReportGroupResponse = createReportGroup(CreateReportGroupRequest.Builder().apply(block).build())

/**
 * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
 *
 * If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then two identical builds are created for each commit. One build is triggered through webhooks, and one through CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the Webhook box. For more information, see step 5 in [Change a Build Project's Settings](https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console).
 */
public suspend inline fun CodeBuildClient.createWebhook(crossinline block: CreateWebhookRequest.Builder.() -> Unit): CreateWebhookResponse = createWebhook(CreateWebhookRequest.Builder().apply(block).build())

/**
 * Deletes a batch build.
 */
public suspend inline fun CodeBuildClient.deleteBuildBatch(crossinline block: DeleteBuildBatchRequest.Builder.() -> Unit): DeleteBuildBatchResponse = deleteBuildBatch(DeleteBuildBatchRequest.Builder().apply(block).build())

/**
 * Deletes a compute fleet. When you delete a compute fleet, its builds are not deleted.
 */
public suspend inline fun CodeBuildClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Deletes a build project. When you delete a project, its builds are not deleted.
 */
public suspend inline fun CodeBuildClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a report.
 */
public suspend inline fun CodeBuildClient.deleteReport(crossinline block: DeleteReportRequest.Builder.() -> Unit): DeleteReportResponse = deleteReport(DeleteReportRequest.Builder().apply(block).build())

/**
 * Deletes a report group. Before you delete a report group, you must delete its reports.
 */
public suspend inline fun CodeBuildClient.deleteReportGroup(crossinline block: DeleteReportGroupRequest.Builder.() -> Unit): DeleteReportGroupResponse = deleteReportGroup(DeleteReportGroupRequest.Builder().apply(block).build())

/**
 * Deletes a resource policy that is identified by its resource ARN.
 */
public suspend inline fun CodeBuildClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
 */
public suspend inline fun CodeBuildClient.deleteSourceCredentials(crossinline block: DeleteSourceCredentialsRequest.Builder.() -> Unit): DeleteSourceCredentialsResponse = deleteSourceCredentials(DeleteSourceCredentialsRequest.Builder().apply(block).build())

/**
 * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
 */
public suspend inline fun CodeBuildClient.deleteWebhook(crossinline block: DeleteWebhookRequest.Builder.() -> Unit): DeleteWebhookResponse = deleteWebhook(DeleteWebhookRequest.Builder().apply(block).build())

/**
 * Retrieves one or more code coverage reports.
 */
public suspend inline fun CodeBuildClient.describeCodeCoverages(crossinline block: DescribeCodeCoveragesRequest.Builder.() -> Unit): DescribeCodeCoveragesResponse = describeCodeCoverages(DescribeCodeCoveragesRequest.Builder().apply(block).build())

/**
 * Returns a list of details about test cases for a report.
 */
public suspend inline fun CodeBuildClient.describeTestCases(crossinline block: DescribeTestCasesRequest.Builder.() -> Unit): DescribeTestCasesResponse = describeTestCases(DescribeTestCasesRequest.Builder().apply(block).build())

/**
 * Analyzes and accumulates test report values for the specified test reports.
 */
public suspend inline fun CodeBuildClient.getReportGroupTrend(crossinline block: GetReportGroupTrendRequest.Builder.() -> Unit): GetReportGroupTrendResponse = getReportGroupTrend(GetReportGroupTrendRequest.Builder().apply(block).build())

/**
 * Gets a resource policy that is identified by its resource ARN.
 */
public suspend inline fun CodeBuildClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket repository.
 */
public suspend inline fun CodeBuildClient.importSourceCredentials(crossinline block: ImportSourceCredentialsRequest.Builder.() -> Unit): ImportSourceCredentialsResponse = importSourceCredentials(ImportSourceCredentialsRequest.Builder().apply(block).build())

/**
 * Resets the cache for a project.
 */
public suspend inline fun CodeBuildClient.invalidateProjectCache(crossinline block: InvalidateProjectCacheRequest.Builder.() -> Unit): InvalidateProjectCacheResponse = invalidateProjectCache(InvalidateProjectCacheRequest.Builder().apply(block).build())

/**
 * Retrieves the identifiers of your build batches in the current region.
 */
public suspend inline fun CodeBuildClient.listBuildBatches(crossinline block: ListBuildBatchesRequest.Builder.() -> Unit): ListBuildBatchesResponse = listBuildBatches(ListBuildBatchesRequest.Builder().apply(block).build())

/**
 * Retrieves the identifiers of the build batches for a specific project.
 */
public suspend inline fun CodeBuildClient.listBuildBatchesForProject(crossinline block: ListBuildBatchesForProjectRequest.Builder.() -> Unit): ListBuildBatchesForProjectResponse = listBuildBatchesForProject(ListBuildBatchesForProjectRequest.Builder().apply(block).build())

/**
 * Gets a list of build IDs, with each build ID representing a single build.
 */
public suspend inline fun CodeBuildClient.listBuilds(crossinline block: ListBuildsRequest.Builder.() -> Unit): ListBuildsResponse = listBuilds(ListBuildsRequest.Builder().apply(block).build())

/**
 * Gets a list of build identifiers for the specified build project, with each build identifier representing a single build.
 */
public suspend inline fun CodeBuildClient.listBuildsForProject(crossinline block: ListBuildsForProjectRequest.Builder.() -> Unit): ListBuildsForProjectResponse = listBuildsForProject(ListBuildsForProjectRequest.Builder().apply(block).build())

/**
 * Gets information about Docker images that are managed by CodeBuild.
 */
public suspend inline fun CodeBuildClient.listCuratedEnvironmentImages(crossinline block: ListCuratedEnvironmentImagesRequest.Builder.() -> Unit): ListCuratedEnvironmentImagesResponse = listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest.Builder().apply(block).build())

/**
 * Gets a list of compute fleet names with each compute fleet name representing a single compute fleet.
 */
public suspend inline fun CodeBuildClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Gets a list of build project names, with each build project name representing a single build project.
 */
public suspend inline fun CodeBuildClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Gets a list ARNs for the report groups in the current Amazon Web Services account.
 */
public suspend inline fun CodeBuildClient.listReportGroups(crossinline block: ListReportGroupsRequest.Builder.() -> Unit): ListReportGroupsResponse = listReportGroups(ListReportGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of ARNs for the reports in the current Amazon Web Services account.
 */
public suspend inline fun CodeBuildClient.listReports(crossinline block: ListReportsRequest.Builder.() -> Unit): ListReportsResponse = listReports(ListReportsRequest.Builder().apply(block).build())

/**
 * Returns a list of ARNs for the reports that belong to a `ReportGroup`.
 */
public suspend inline fun CodeBuildClient.listReportsForReportGroup(crossinline block: ListReportsForReportGroupRequest.Builder.() -> Unit): ListReportsForReportGroupResponse = listReportsForReportGroup(ListReportsForReportGroupRequest.Builder().apply(block).build())

/**
 * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
 */
public suspend inline fun CodeBuildClient.listSharedProjects(crossinline block: ListSharedProjectsRequest.Builder.() -> Unit): ListSharedProjectsResponse = listSharedProjects(ListSharedProjectsRequest.Builder().apply(block).build())

/**
 * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
 */
public suspend inline fun CodeBuildClient.listSharedReportGroups(crossinline block: ListSharedReportGroupsRequest.Builder.() -> Unit): ListSharedReportGroupsResponse = listSharedReportGroups(ListSharedReportGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of `SourceCredentialsInfo` objects.
 */
public suspend inline fun CodeBuildClient.listSourceCredentials(crossinline block: ListSourceCredentialsRequest.Builder.() -> Unit): ListSourceCredentialsResponse = listSourceCredentials(ListSourceCredentialsRequest.Builder().apply(block).build())

/**
 * Stores a resource policy for the ARN of a `Project` or `ReportGroup` object.
 */
public suspend inline fun CodeBuildClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Restarts a build.
 */
public suspend inline fun CodeBuildClient.retryBuild(crossinline block: RetryBuildRequest.Builder.() -> Unit): RetryBuildResponse = retryBuild(RetryBuildRequest.Builder().apply(block).build())

/**
 * Restarts a failed batch build. Only batch builds that have failed can be retried.
 */
public suspend inline fun CodeBuildClient.retryBuildBatch(crossinline block: RetryBuildBatchRequest.Builder.() -> Unit): RetryBuildBatchResponse = retryBuildBatch(RetryBuildBatchRequest.Builder().apply(block).build())

/**
 * Starts running a build with the settings defined in the project. These setting include: how to run a build, where to get the source code, which build environment to use, which build commands to run, and where to store the build output.
 *
 * You can also start a build run by overriding some of the build settings in the project. The overrides only apply for that specific start build request. The settings in the project are unaltered.
 */
public suspend inline fun CodeBuildClient.startBuild(crossinline block: StartBuildRequest.Builder.() -> Unit): StartBuildResponse = startBuild(StartBuildRequest.Builder().apply(block).build())

/**
 * Starts a batch build for a project.
 */
public suspend inline fun CodeBuildClient.startBuildBatch(crossinline block: StartBuildBatchRequest.Builder.() -> Unit): StartBuildBatchResponse = startBuildBatch(StartBuildBatchRequest.Builder().apply(block).build())

/**
 * Attempts to stop running a build.
 */
public suspend inline fun CodeBuildClient.stopBuild(crossinline block: StopBuildRequest.Builder.() -> Unit): StopBuildResponse = stopBuild(StopBuildRequest.Builder().apply(block).build())

/**
 * Stops a running batch build.
 */
public suspend inline fun CodeBuildClient.stopBuildBatch(crossinline block: StopBuildBatchRequest.Builder.() -> Unit): StopBuildBatchResponse = stopBuildBatch(StopBuildBatchRequest.Builder().apply(block).build())

/**
 * Updates a compute fleet.
 */
public suspend inline fun CodeBuildClient.updateFleet(crossinline block: UpdateFleetRequest.Builder.() -> Unit): UpdateFleetResponse = updateFleet(UpdateFleetRequest.Builder().apply(block).build())

/**
 * Changes the settings of a build project.
 */
public suspend inline fun CodeBuildClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Changes the public visibility for a project. The project's build results, logs, and artifacts are available to the general public. For more information, see [Public build projects](https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html) in the *CodeBuild User Guide*.
 *
 * The following should be kept in mind when making your projects public:
 * + All of a project's build results, logs, and artifacts, including builds that were run when the project was private, are available to the general public.
 * + All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive information may have been output to the build logs and artifacts. You must be careful about what information is output to the build logs. Some best practice are:
 *    + Do not store sensitive values in environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store or Secrets Manager to store sensitive values.
 *    + Follow [Best practices for using webhooks](https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices) in the *CodeBuild User Guide* to limit which entities can trigger a build, and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.
 * + A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull requests to verify that the pull request is a legitimate change. We also recommend that you validate any artifacts with their checksums to make sure that the correct artifacts are being downloaded.
 */
public suspend inline fun CodeBuildClient.updateProjectVisibility(crossinline block: UpdateProjectVisibilityRequest.Builder.() -> Unit): UpdateProjectVisibilityResponse = updateProjectVisibility(UpdateProjectVisibilityRequest.Builder().apply(block).build())

/**
 * Updates a report group.
 */
public suspend inline fun CodeBuildClient.updateReportGroup(crossinline block: UpdateReportGroupRequest.Builder.() -> Unit): UpdateReportGroupResponse = updateReportGroup(UpdateReportGroupRequest.Builder().apply(block).build())

/**
 * Updates the webhook associated with an CodeBuild build project.
 *
 *  If you use Bitbucket for your repository, `rotateSecret` is ignored.
 */
public suspend inline fun CodeBuildClient.updateWebhook(crossinline block: UpdateWebhookRequest.Builder.() -> Unit): UpdateWebhookResponse = updateWebhook(UpdateWebhookRequest.Builder().apply(block).build())
