// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.serde

import aws.sdk.kotlin.services.codebuild.model.LogsConfig
import aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts
import aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig
import aws.sdk.kotlin.services.codebuild.model.ProjectCache
import aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment
import aws.sdk.kotlin.services.codebuild.model.ProjectFileSystemLocation
import aws.sdk.kotlin.services.codebuild.model.ProjectSource
import aws.sdk.kotlin.services.codebuild.model.ProjectSourceVersion
import aws.sdk.kotlin.services.codebuild.model.Tag
import aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest
import aws.sdk.kotlin.services.codebuild.model.VpcConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateProjectOperationSerializer: HttpSerialize<UpdateProjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateProjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateProjectOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateProjectOperationBody(context: ExecutionContext, input: UpdateProjectRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("artifacts"))
    val BADGEENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("badgeEnabled"))
    val BUILDBATCHCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("buildBatchConfig"))
    val CACHE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cache"))
    val CONCURRENTBUILDLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("concurrentBuildLimit"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("encryptionKey"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("environment"))
    val FILESYSTEMLOCATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("fileSystemLocations"))
    val LOGSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logsConfig"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val QUEUEDTIMEOUTINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("queuedTimeoutInMinutes"))
    val SECONDARYARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("secondaryArtifacts"))
    val SECONDARYSOURCEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("secondarySourceVersions"))
    val SECONDARYSOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("secondarySources"))
    val SERVICEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceRole"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("source"))
    val SOURCEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceVersion"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TIMEOUTINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutInMinutes"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTS_DESCRIPTOR)
        field(BADGEENABLED_DESCRIPTOR)
        field(BUILDBATCHCONFIG_DESCRIPTOR)
        field(CACHE_DESCRIPTOR)
        field(CONCURRENTBUILDLIMIT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENCRYPTIONKEY_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(FILESYSTEMLOCATIONS_DESCRIPTOR)
        field(LOGSCONFIG_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(QUEUEDTIMEOUTINMINUTES_DESCRIPTOR)
        field(SECONDARYARTIFACTS_DESCRIPTOR)
        field(SECONDARYSOURCEVERSIONS_DESCRIPTOR)
        field(SECONDARYSOURCES_DESCRIPTOR)
        field(SERVICEROLE_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCEVERSION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEOUTINMINUTES_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.artifacts?.let { field(ARTIFACTS_DESCRIPTOR, it, ::serializeProjectArtifactsDocument) }
        input.badgeEnabled?.let { field(BADGEENABLED_DESCRIPTOR, it) }
        input.buildBatchConfig?.let { field(BUILDBATCHCONFIG_DESCRIPTOR, it, ::serializeProjectBuildBatchConfigDocument) }
        input.cache?.let { field(CACHE_DESCRIPTOR, it, ::serializeProjectCacheDocument) }
        input.concurrentBuildLimit?.let { field(CONCURRENTBUILDLIMIT_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.encryptionKey?.let { field(ENCRYPTIONKEY_DESCRIPTOR, it) }
        input.environment?.let { field(ENVIRONMENT_DESCRIPTOR, it, ::serializeProjectEnvironmentDocument) }
        if (input.fileSystemLocations != null) {
            listField(FILESYSTEMLOCATIONS_DESCRIPTOR) {
                for (el0 in input.fileSystemLocations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProjectFileSystemLocationDocument))
                }
            }
        }
        input.logsConfig?.let { field(LOGSCONFIG_DESCRIPTOR, it, ::serializeLogsConfigDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.queuedTimeoutInMinutes?.let { field(QUEUEDTIMEOUTINMINUTES_DESCRIPTOR, it) }
        if (input.secondaryArtifacts != null) {
            listField(SECONDARYARTIFACTS_DESCRIPTOR) {
                for (el0 in input.secondaryArtifacts) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProjectArtifactsDocument))
                }
            }
        }
        if (input.secondarySourceVersions != null) {
            listField(SECONDARYSOURCEVERSIONS_DESCRIPTOR) {
                for (el0 in input.secondarySourceVersions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProjectSourceVersionDocument))
                }
            }
        }
        if (input.secondarySources != null) {
            listField(SECONDARYSOURCES_DESCRIPTOR) {
                for (el0 in input.secondarySources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProjectSourceDocument))
                }
            }
        }
        input.serviceRole?.let { field(SERVICEROLE_DESCRIPTOR, it) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it, ::serializeProjectSourceDocument) }
        input.sourceVersion?.let { field(SOURCEVERSION_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.timeoutInMinutes?.let { field(TIMEOUTINMINUTES_DESCRIPTOR, it) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigDocument) }
    }
    return serializer.toByteArray()
}
