// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about the build output artifacts for the build project.
 */
public class ProjectArtifacts private constructor(builder: Builder) {
    /**
     * An identifier for this artifact definition.
     */
    public val artifactIdentifier: kotlin.String? = builder.artifactIdentifier
    /**
     * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
     *
     * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     *
     * This property can be one of the following values:
     *
     * ## NONE
     * The bucket owner does not have access to the objects. This is the default.
     *
     * ## READ_ONLY
     * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
     *
     * ## FULL
     * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
     * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
     * + Otherwise, the uploading account retains ownership of the objects.
     * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = builder.bucketOwnerAccess
    /**
     * Set to true if you do not want your output artifacts encrypted. This option is valid only if your artifacts type is Amazon S3. If this is set with another artifacts type, an invalidInputException is thrown.
     */
    public val encryptionDisabled: kotlin.Boolean? = builder.encryptionDisabled
    /**
     * Information about the build output artifact location:
     * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output locations instead of CodeBuild.
     * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
     * + If `type` is set to `S3`, this is the name of the output bucket.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Along with `path` and `namespaceType`, the pattern that CodeBuild uses to name and store the output artifact:
     * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
     * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
     * + If `type` is set to `S3`, this is the name of the output artifact object. If you set the name to be a forward slash ("/"), the artifact is stored in the root of the output bucket.
     *
     * For example:
     * +  If `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to `MyArtifact.zip`, then the output artifact is stored in `MyArtifacts/<build-ID>/MyArtifact.zip`.
     * +  If `path` is empty, `namespaceType` is set to `NONE`, and `name` is set to "`/`", the output artifact is stored in the root of the output bucket.
     * +  If `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to "`/`", the output artifact is stored in `MyArtifacts/<build-ID>`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Along with `path` and `name`, the pattern that CodeBuild uses to determine the name and location to store the output artifact:
     * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
     * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
     * + If `type` is set to `S3`, valid values include:
     *    + `BUILD_ID`: Include the build ID in the location of the build output artifact.
     *    + `NONE`: Do not include the build ID. This is the default if `namespaceType` is not specified.
     *
     * For example, if `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to `MyArtifact.zip`, the output artifact is stored in `MyArtifacts/<build-ID>/MyArtifact.zip`.
     */
    public val namespaceType: aws.sdk.kotlin.services.codebuild.model.ArtifactNamespace? = builder.namespaceType
    /**
     * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified in a buildspec file is calculated at build time and uses the Shell Command Language. For example, you can append a date and time to your artifact name so that it is always unique.
     */
    public val overrideArtifactName: kotlin.Boolean? = builder.overrideArtifactName
    /**
     * The type of build output artifact to create:
     * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output artifacts instead of CodeBuild.
     * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
     * + If `type` is set to `S3`, valid values include:
     *    + `NONE`: CodeBuild creates in the output bucket a folder that contains the build output. This is the default if `packaging` is not specified.
     *    + `ZIP`: CodeBuild creates in the output bucket a ZIP file that contains the build output.
     */
    public val packaging: aws.sdk.kotlin.services.codebuild.model.ArtifactPackaging? = builder.packaging
    /**
     * Along with `namespaceType` and `name`, the pattern that CodeBuild uses to name and store the output artifact:
     * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
     * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
     * + If `type` is set to `S3`, this is the path to the output artifact. If `path` is not specified, `path` is not used.
     *
     * For example, if `path` is set to `MyArtifacts`, `namespaceType` is set to `NONE`, and `name` is set to `MyArtifact.zip`, the output artifact is stored in the output bucket at `MyArtifacts/MyArtifact.zip`.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The type of build output artifact. Valid values include:
     * + `CODEPIPELINE`: The build project has build output generated through CodePipeline. The `CODEPIPELINE` type is not supported for `secondaryArtifacts`.
     * + `NO_ARTIFACTS`: The build project does not produce any build output.
     * + `S3`: The build project stores build output in Amazon S3.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.ArtifactsType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectArtifacts(")
        append("artifactIdentifier=$artifactIdentifier,")
        append("bucketOwnerAccess=$bucketOwnerAccess,")
        append("encryptionDisabled=$encryptionDisabled,")
        append("location=$location,")
        append("name=$name,")
        append("namespaceType=$namespaceType,")
        append("overrideArtifactName=$overrideArtifactName,")
        append("packaging=$packaging,")
        append("path=$path,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactIdentifier?.hashCode() ?: 0
        result = 31 * result + (bucketOwnerAccess?.hashCode() ?: 0)
        result = 31 * result + (encryptionDisabled?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespaceType?.hashCode() ?: 0)
        result = 31 * result + (overrideArtifactName?.hashCode() ?: 0)
        result = 31 * result + (packaging?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectArtifacts

        if (artifactIdentifier != other.artifactIdentifier) return false
        if (bucketOwnerAccess != other.bucketOwnerAccess) return false
        if (encryptionDisabled != other.encryptionDisabled) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (namespaceType != other.namespaceType) return false
        if (overrideArtifactName != other.overrideArtifactName) return false
        if (packaging != other.packaging) return false
        if (path != other.path) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An identifier for this artifact definition.
         */
        public var artifactIdentifier: kotlin.String? = null
        /**
         * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
         *
         * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
         *
         * This property can be one of the following values:
         *
         * ## NONE
         * The bucket owner does not have access to the objects. This is the default.
         *
         * ## READ_ONLY
         * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
         *
         * ## FULL
         * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
         * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
         * + Otherwise, the uploading account retains ownership of the objects.
         * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = null
        /**
         * Set to true if you do not want your output artifacts encrypted. This option is valid only if your artifacts type is Amazon S3. If this is set with another artifacts type, an invalidInputException is thrown.
         */
        public var encryptionDisabled: kotlin.Boolean? = null
        /**
         * Information about the build output artifact location:
         * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output locations instead of CodeBuild.
         * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
         * + If `type` is set to `S3`, this is the name of the output bucket.
         */
        public var location: kotlin.String? = null
        /**
         * Along with `path` and `namespaceType`, the pattern that CodeBuild uses to name and store the output artifact:
         * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
         * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
         * + If `type` is set to `S3`, this is the name of the output artifact object. If you set the name to be a forward slash ("/"), the artifact is stored in the root of the output bucket.
         *
         * For example:
         * +  If `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to `MyArtifact.zip`, then the output artifact is stored in `MyArtifacts/<build-ID>/MyArtifact.zip`.
         * +  If `path` is empty, `namespaceType` is set to `NONE`, and `name` is set to "`/`", the output artifact is stored in the root of the output bucket.
         * +  If `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to "`/`", the output artifact is stored in `MyArtifacts/<build-ID>`.
         */
        public var name: kotlin.String? = null
        /**
         * Along with `path` and `name`, the pattern that CodeBuild uses to determine the name and location to store the output artifact:
         * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
         * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
         * + If `type` is set to `S3`, valid values include:
         *    + `BUILD_ID`: Include the build ID in the location of the build output artifact.
         *    + `NONE`: Do not include the build ID. This is the default if `namespaceType` is not specified.
         *
         * For example, if `path` is set to `MyArtifacts`, `namespaceType` is set to `BUILD_ID`, and `name` is set to `MyArtifact.zip`, the output artifact is stored in `MyArtifacts/<build-ID>/MyArtifact.zip`.
         */
        public var namespaceType: aws.sdk.kotlin.services.codebuild.model.ArtifactNamespace? = null
        /**
         * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified in a buildspec file is calculated at build time and uses the Shell Command Language. For example, you can append a date and time to your artifact name so that it is always unique.
         */
        public var overrideArtifactName: kotlin.Boolean? = null
        /**
         * The type of build output artifact to create:
         * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output artifacts instead of CodeBuild.
         * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
         * + If `type` is set to `S3`, valid values include:
         *    + `NONE`: CodeBuild creates in the output bucket a folder that contains the build output. This is the default if `packaging` is not specified.
         *    + `ZIP`: CodeBuild creates in the output bucket a ZIP file that contains the build output.
         */
        public var packaging: aws.sdk.kotlin.services.codebuild.model.ArtifactPackaging? = null
        /**
         * Along with `namespaceType` and `name`, the pattern that CodeBuild uses to name and store the output artifact:
         * + If `type` is set to `CODEPIPELINE`, CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of CodeBuild.
         * + If `type` is set to `NO_ARTIFACTS`, this value is ignored if specified, because no build output is produced.
         * + If `type` is set to `S3`, this is the path to the output artifact. If `path` is not specified, `path` is not used.
         *
         * For example, if `path` is set to `MyArtifacts`, `namespaceType` is set to `NONE`, and `name` is set to `MyArtifact.zip`, the output artifact is stored in the output bucket at `MyArtifacts/MyArtifact.zip`.
         */
        public var path: kotlin.String? = null
        /**
         * The type of build output artifact. Valid values include:
         * + `CODEPIPELINE`: The build project has build output generated through CodePipeline. The `CODEPIPELINE` type is not supported for `secondaryArtifacts`.
         * + `NO_ARTIFACTS`: The build project does not produce any build output.
         * + `S3`: The build project stores build output in Amazon S3.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.ArtifactsType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts) : this() {
            this.artifactIdentifier = x.artifactIdentifier
            this.bucketOwnerAccess = x.bucketOwnerAccess
            this.encryptionDisabled = x.encryptionDisabled
            this.location = x.location
            this.name = x.name
            this.namespaceType = x.namespaceType
            this.overrideArtifactName = x.overrideArtifactName
            this.packaging = x.packaging
            this.path = x.path
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts = ProjectArtifacts(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = ArtifactsType.SdkUnknown("no value provided")
            return this
        }
    }
}
