// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class GetReportGroupTrendRequest private constructor(builder: Builder) {
    /**
     * The number of reports to analyze. This operation always retrieves the most recent reports.
     *
     * If this parameter is omitted, the most recent 100 reports are analyzed.
     */
    public val numOfReports: kotlin.Int? = builder.numOfReports
    /**
     * The ARN of the report group that contains the reports to analyze.
     */
    public val reportGroupArn: kotlin.String? = builder.reportGroupArn
    /**
     * The test report value to accumulate. This must be one of the following values:
     *
     * ## Test reports:
     * ## DURATION
     * Accumulate the test run times for the specified reports.
     *
     * ## PASS_RATE
     * Accumulate the percentage of tests that passed for the specified test reports.
     *
     * ## TOTAL
     * Accumulate the total number of tests for the specified test reports.
     *
     * ## Code coverage reports:
     * ## BRANCH_COVERAGE
     * Accumulate the branch coverage percentages for the specified test reports.
     *
     * ## BRANCHES_COVERED
     * Accumulate the branches covered values for the specified test reports.
     *
     * ## BRANCHES_MISSED
     * Accumulate the branches missed values for the specified test reports.
     *
     * ## LINE_COVERAGE
     * Accumulate the line coverage percentages for the specified test reports.
     *
     * ## LINES_COVERED
     * Accumulate the lines covered values for the specified test reports.
     *
     * ## LINES_MISSED
     * Accumulate the lines not covered values for the specified test reports.
     */
    public val trendField: aws.sdk.kotlin.services.codebuild.model.ReportGroupTrendFieldType? = builder.trendField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetReportGroupTrendRequest(")
        append("numOfReports=$numOfReports,")
        append("reportGroupArn=$reportGroupArn,")
        append("trendField=$trendField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = numOfReports ?: 0
        result = 31 * result + (reportGroupArn?.hashCode() ?: 0)
        result = 31 * result + (trendField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetReportGroupTrendRequest

        if (numOfReports != other.numOfReports) return false
        if (reportGroupArn != other.reportGroupArn) return false
        if (trendField != other.trendField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of reports to analyze. This operation always retrieves the most recent reports.
         *
         * If this parameter is omitted, the most recent 100 reports are analyzed.
         */
        public var numOfReports: kotlin.Int? = null
        /**
         * The ARN of the report group that contains the reports to analyze.
         */
        public var reportGroupArn: kotlin.String? = null
        /**
         * The test report value to accumulate. This must be one of the following values:
         *
         * ## Test reports:
         * ## DURATION
         * Accumulate the test run times for the specified reports.
         *
         * ## PASS_RATE
         * Accumulate the percentage of tests that passed for the specified test reports.
         *
         * ## TOTAL
         * Accumulate the total number of tests for the specified test reports.
         *
         * ## Code coverage reports:
         * ## BRANCH_COVERAGE
         * Accumulate the branch coverage percentages for the specified test reports.
         *
         * ## BRANCHES_COVERED
         * Accumulate the branches covered values for the specified test reports.
         *
         * ## BRANCHES_MISSED
         * Accumulate the branches missed values for the specified test reports.
         *
         * ## LINE_COVERAGE
         * Accumulate the line coverage percentages for the specified test reports.
         *
         * ## LINES_COVERED
         * Accumulate the lines covered values for the specified test reports.
         *
         * ## LINES_MISSED
         * Accumulate the lines not covered values for the specified test reports.
         */
        public var trendField: aws.sdk.kotlin.services.codebuild.model.ReportGroupTrendFieldType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendRequest) : this() {
            this.numOfReports = x.numOfReports
            this.reportGroupArn = x.reportGroupArn
            this.trendField = x.trendField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.GetReportGroupTrendRequest = GetReportGroupTrendRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
