// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class CreateFleetRequest private constructor(builder: Builder) {
    /**
     * The initial number of machines allocated to the ﬂeet, which deﬁnes the number of builds that can run in parallel.
     */
    public val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * Information about the compute resources the compute fleet uses. Available values include:
     * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
     * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
     * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
     *
     *  If you use `BUILD_GENERAL1_SMALL`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
     *
     *  If you use `BUILD_GENERAL1_LARGE`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
     */
    public val computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = builder.computeType
    /**
     * The environment type of the compute fleet.
     * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
     * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
     * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
     */
    public val environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = builder.environmentType
    /**
     * The name of the compute fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The scaling configuration of the compute fleet.
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationInput? = builder.scalingConfiguration
    /**
     * A list of tag key and value pairs associated with this compute fleet.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.CreateFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetRequest(")
        append("baseCapacity=$baseCapacity,")
        append("computeType=$computeType,")
        append("environmentType=$environmentType,")
        append("name=$name,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCapacity ?: 0
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (environmentType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFleetRequest

        if (baseCapacity != other.baseCapacity) return false
        if (computeType != other.computeType) return false
        if (environmentType != other.environmentType) return false
        if (name != other.name) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.CreateFleetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The initial number of machines allocated to the ﬂeet, which deﬁnes the number of builds that can run in parallel.
         */
        public var baseCapacity: kotlin.Int? = null
        /**
         * Information about the compute resources the compute fleet uses. Available values include:
         * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
         * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
         * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
         *
         *  If you use `BUILD_GENERAL1_SMALL`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
         *
         *  If you use `BUILD_GENERAL1_LARGE`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
         */
        public var computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = null
        /**
         * The environment type of the compute fleet.
         * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
         * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
         * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
         */
        public var environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = null
        /**
         * The name of the compute fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The scaling configuration of the compute fleet.
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationInput? = null
        /**
         * A list of tag key and value pairs associated with this compute fleet.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.CreateFleetRequest) : this() {
            this.baseCapacity = x.baseCapacity
            this.computeType = x.computeType
            this.environmentType = x.environmentType
            this.name = x.name
            this.scalingConfiguration = x.scalingConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.CreateFleetRequest = CreateFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationInput] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationInput.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
